/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.CommonOdsDocument;
import com.github.jferard.fastods.FastOdsException;
import com.github.jferard.fastods.NamedOdsFileWriter;
import com.github.jferard.fastods.OdsDocument;
import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.TableCell;
import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.style.MasterPageStyle;
import com.github.jferard.fastods.style.ObjectStyle;
import com.github.jferard.fastods.style.PageLayoutStyle;
import com.github.jferard.fastods.style.PageStyle;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NamedOdsDocument
implements OdsDocument {
    private final Logger logger;
    private final OdsElements odsElements;
    private final XMLUtil xmlUtil;
    private final CommonOdsDocument commonOdsDocument;

    static NamedOdsDocument create(Logger logger, XMLUtil xmlUtil, OdsElements odsElements) {
        return new NamedOdsDocument(logger, xmlUtil, odsElements, new CommonOdsDocument(odsElements));
    }

    NamedOdsDocument(Logger logger, XMLUtil xmlUtil, OdsElements odsElements, CommonOdsDocument commonOdsDocument) {
        this.logger = logger;
        this.odsElements = odsElements;
        this.xmlUtil = xmlUtil;
        this.commonOdsDocument = commonOdsDocument;
    }

    @Override
    public Table addTable(String name) throws IOException {
        return this.commonOdsDocument.addTable(name);
    }

    @Override
    public Table addTable(String name, int rowCapacity, int columnCapacity) throws IOException {
        return this.commonOdsDocument.addTable(name, rowCapacity, columnCapacity);
    }

    @Override
    public Table getTable(int n) throws FastOdsException {
        return this.commonOdsDocument.getTable(n);
    }

    @Override
    public Table getTable(String name) throws FastOdsException {
        return this.commonOdsDocument.getTable(name);
    }

    @Override
    public Table getOrAddTable(String name) throws IOException {
        return this.commonOdsDocument.getOrAddTable(name);
    }

    @Override
    public String getTableName(int n) throws FastOdsException {
        return this.commonOdsDocument.getTableName(n);
    }

    @Override
    public int getTableNumber(String name) {
        return this.commonOdsDocument.getTableNumber(name);
    }

    @Override
    public List<Table> getTables() {
        return this.commonOdsDocument.getTables();
    }

    @Override
    public boolean setActiveTable(int tableIndex) {
        return this.commonOdsDocument.setActiveTable(tableIndex);
    }

    @Override
    public void setViewSetting(String viewId, String item, String value) {
        this.commonOdsDocument.setViewSetting(viewId, item, value);
    }

    @Override
    public int tableCount() {
        return this.commonOdsDocument.tableCount();
    }

    @Override
    public void addAutoFilter(Table table, int r1, int c1, int r2, int c2) {
        this.commonOdsDocument.addAutoFilter(table, r1, c1, r2, c2);
    }

    @Override
    public void freezeCells(Table table, int rowCount, int colCount) {
        this.commonOdsDocument.freezeCells(table, rowCount, colCount);
    }

    public void addChildCellStyle(TableCell.Type type) {
        this.odsElements.addChildCellStyle(TableCellStyle.DEFAULT_CELL_STYLE, type);
    }

    public void addChildCellStyle(TableCellStyle style, TableCell.Type type) {
        this.odsElements.addChildCellStyle(style, type);
    }

    public void addDataStyle(DataStyle dataStyle) {
        this.odsElements.addDataStyle(dataStyle);
    }

    public void addMasterPageStyle(MasterPageStyle masterPageStyle) {
        this.odsElements.addMasterPageStyle(masterPageStyle);
    }

    void addObserver(NamedOdsFileWriter writer) {
        this.odsElements.addObserver(writer);
    }

    public void addPageLayoutStyle(PageLayoutStyle pageLayoutStyle) {
        this.odsElements.addPageLayoutStyle(pageLayoutStyle);
    }

    public void addPageStyle(PageStyle ps) {
        this.odsElements.addPageStyle(ps);
    }

    public void addObjectStyle(ObjectStyle objectStyle) {
        this.odsElements.addContentStyle(objectStyle);
    }

    public void addStyleToContentAutomaticStyles(ObjectStyle objectStyle) {
        this.odsElements.addStyleToContentAutomaticStyles(objectStyle);
    }

    public void debugStyles() {
        this.odsElements.debugStyles();
    }

    public void freezeStyles() {
        this.odsElements.freezeStyles();
    }

    public void prepareFlush() throws IOException {
        this.odsElements.prepare();
    }

    public void save() throws IOException {
        this.odsElements.save();
    }

    public void save(ZipUTF8Writer writer) throws IOException {
        try {
            this.odsElements.writeMeta(this.xmlUtil, writer);
            this.odsElements.writeStyles(this.xmlUtil, writer);
            this.odsElements.writeContent(this.xmlUtil, writer);
            this.odsElements.writeSettings(this.xmlUtil, writer);
        }
        finally {
            writer.close();
        }
        this.logger.log(Level.FINE, "file saved");
    }
}

