/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.FastOdsException;
import com.github.jferard.fastods.OdsDocument;
import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.style.PageStyle;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.style.TableColumnStyle;
import com.github.jferard.fastods.style.TableRowStyle;
import com.github.jferard.fastods.style.TableStyle;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;

class CommonOdsDocument
implements OdsDocument {
    static final int DEFAULT_COLUMN_CAPACITY = 32;
    static final int DEFAULT_ROW_CAPACITY = 1024;
    private final OdsElements odsElements;

    CommonOdsDocument(OdsElements odsElements) {
        this.odsElements = odsElements;
        TableStyle.DEFAULT_TABLE_STYLE.addToElements(this.odsElements);
        TableRowStyle.DEFAULT_TABLE_ROW_STYLE.addToElements(this.odsElements);
        TableColumnStyle.DEFAULT_TABLE_COLUMN_STYLE.addToElements(this.odsElements);
        TableCellStyle.DEFAULT_CELL_STYLE.addToElements(this.odsElements);
        PageStyle.DEFAULT_PAGE_STYLE.addToElements(this.odsElements);
    }

    @Override
    public Table addTable(String name) throws IOException {
        return this.addTable(name, 1024, 32);
    }

    @Override
    public Table addTable(String name, int rowCapacity, int columnCapacity) throws IOException {
        Table table = this.odsElements.addTableToContent(name, rowCapacity, columnCapacity);
        this.odsElements.setActiveTable(table);
        return table;
    }

    @Override
    public Table getTable(int n) throws FastOdsException {
        List<Table> tables = this.odsElements.getTables();
        if (n < 0 || n >= tables.size()) {
            throw FastOdsException.wrongTableNumber(n);
        }
        return tables.get(n);
    }

    @Override
    public Table getTable(String name) throws FastOdsException {
        Table table = this.odsElements.getTable(name);
        if (table == null) {
            throw FastOdsException.wrongTableName(name);
        }
        return table;
    }

    @Override
    public Table getOrAddTable(String name) throws IOException {
        Table table = this.odsElements.getTable(name);
        if (table == null) {
            table = this.addTable(name);
        }
        return table;
    }

    @Override
    public String getTableName(int n) throws FastOdsException {
        Table t = this.getTable(n);
        return t.getName();
    }

    @Override
    public int getTableNumber(String name) {
        ListIterator<Table> iterator = this.odsElements.getTables().listIterator();
        while (iterator.hasNext()) {
            int n = iterator.nextIndex();
            Table tab = iterator.next();
            if (!tab.getName().equals(name)) continue;
            return n;
        }
        return -1;
    }

    @Override
    public List<Table> getTables() {
        return this.odsElements.getTables();
    }

    @Override
    public boolean setActiveTable(int tableIndex) {
        if (tableIndex < 0 || tableIndex >= this.odsElements.getTableCount()) {
            return false;
        }
        Table table = this.odsElements.getTable(tableIndex);
        this.odsElements.setActiveTable(table);
        return true;
    }

    @Override
    public void setViewSetting(String viewId, String item, String value) {
        this.odsElements.setViewSetting(viewId, item, value);
    }

    @Override
    public int tableCount() {
        return this.odsElements.getTableCount();
    }

    @Override
    public void addAutoFilter(Table table, int r1, int c1, int r2, int c2) {
        this.odsElements.addAutoFilter(table, r1, c1, r2, c2);
    }

    @Override
    public void freezeCells(Table table, int rowCount, int colCount) {
        this.odsElements.freezeCells(table, rowCount, colCount);
    }
}

