/*
 * Decompiled with CFR 0.152.
 */
package com.github.rcaller.rstuff;

import com.github.rcaller.rstuff.FailurePolicy;
import com.github.rcaller.rstuff.RProcessStartUpOptions;
import com.github.rcaller.util.Globals;

public class RCallerOptions {
    private static final long ININITAL_WAIT_TIME = 100L;
    private String rScriptExecutable;
    private String rExecutable;
    private FailurePolicy failurePolicy;
    private long maxWaitTime;
    private long initialWaitTime;
    private RProcessStartUpOptions rProcessStartUpOptions;
    private int retries;

    private RCallerOptions(String rScriptExecutable, String rExecutable, FailurePolicy failurePolicy, long maxWaitTime, long initialWaitTime, RProcessStartUpOptions rProcessStartUpOptions) {
        this.rScriptExecutable = rScriptExecutable;
        this.rExecutable = rExecutable;
        this.failurePolicy = failurePolicy;
        this.maxWaitTime = maxWaitTime;
        this.initialWaitTime = initialWaitTime;
        this.rProcessStartUpOptions = rProcessStartUpOptions;
        this.retries = 0;
    }

    public static RCallerOptions create() {
        Globals.detect_current_rscript();
        return new RCallerOptions(Globals.Rscript_current, Globals.R_current, FailurePolicy.RETRY_5, Long.MAX_VALUE, 100L, RProcessStartUpOptions.create());
    }

    public static RCallerOptions create(RProcessStartUpOptions rProcessStartUpOptions) {
        Globals.detect_current_rscript();
        return new RCallerOptions(Globals.Rscript_current, Globals.R_current, FailurePolicy.RETRY_5, Long.MAX_VALUE, 100L, rProcessStartUpOptions);
    }

    public static RCallerOptions create(FailurePolicy failurePolicy, long maxWaitTime) {
        Globals.detect_current_rscript();
        return new RCallerOptions(Globals.Rscript_current, Globals.R_current, failurePolicy, maxWaitTime, 100L, RProcessStartUpOptions.create());
    }

    public static RCallerOptions create(FailurePolicy failurePolicy, long maxWaitTime, RProcessStartUpOptions rProcessStartUpOptions) {
        Globals.detect_current_rscript();
        return new RCallerOptions(Globals.Rscript_current, Globals.R_current, failurePolicy, maxWaitTime, 100L, rProcessStartUpOptions);
    }

    public static RCallerOptions create(FailurePolicy failurePolicy, long maxWaitTime, long initialWaitTime, RProcessStartUpOptions rProcessStartUpOptions) {
        Globals.detect_current_rscript();
        return new RCallerOptions(Globals.Rscript_current, Globals.R_current, failurePolicy, maxWaitTime, initialWaitTime, rProcessStartUpOptions);
    }

    public static RCallerOptions create(String rScriptExecutable, String rExecutable, FailurePolicy failurePolicy, long maxWaitTime, long initialWaitTime, RProcessStartUpOptions rProcessStartUpOptions) {
        return new RCallerOptions(rScriptExecutable, rExecutable, failurePolicy, maxWaitTime, initialWaitTime, rProcessStartUpOptions);
    }

    public String getrScriptExecutable() {
        return this.rScriptExecutable;
    }

    public String getrExecutable() {
        return this.rExecutable;
    }

    public FailurePolicy getFailurePolicy() {
        return this.failurePolicy;
    }

    public long getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public long getInitialWaitTime() {
        return this.initialWaitTime;
    }

    public RProcessStartUpOptions getrProcessStartUpOptions() {
        return this.rProcessStartUpOptions;
    }

    public int getRetries() {
        return this.retries;
    }

    public String getStartUpOptionsAsCommand() {
        return this.rProcessStartUpOptions.getStartUpOptionsAsCommand();
    }

    public void incrementRetries() {
        ++this.retries;
    }

    public void resetRetries() {
        this.retries = 0;
    }
}

