/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparser;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.SwitchStmt;
import java.util.List;
import java.util.Optional;

public final class Navigator {
    private Navigator() {
    }

    @Deprecated
    public static Node getParentNode(Node node) {
        return node.getParentNode().orElse(null);
    }

    public static Node requireParentNode(Node node) {
        return (Node)node.getParentNode().orElseThrow(() -> new IllegalStateException("Parent not found, the node does not appear to be inserted in a correct AST"));
    }

    public static Optional<TypeDeclaration<?>> findType(CompilationUnit cu, String qualifiedName) {
        if (cu.getTypes().isEmpty()) {
            return Optional.empty();
        }
        String typeName = Navigator.getOuterTypeName(qualifiedName);
        Optional<TypeDeclaration<?>> type = cu.getTypes().stream().filter(t -> t.getName().getId().equals(typeName)).findFirst();
        String innerTypeName = Navigator.getInnerTypeName(qualifiedName);
        if (type.isPresent() && !innerTypeName.isEmpty()) {
            return Navigator.findType(type.get(), innerTypeName);
        }
        return type;
    }

    public static Optional<TypeDeclaration<?>> findType(TypeDeclaration<?> td, String qualifiedName) {
        String typeName = Navigator.getOuterTypeName(qualifiedName);
        Optional<TypeDeclaration<?>> type = Optional.empty();
        for (Node n : td.getMembers()) {
            if (!(n instanceof TypeDeclaration) || !((TypeDeclaration)n).getName().getId().equals(typeName)) continue;
            type = Optional.of((TypeDeclaration)n);
            break;
        }
        String innerTypeName = Navigator.getInnerTypeName(qualifiedName);
        if (type.isPresent() && !innerTypeName.isEmpty()) {
            return Navigator.findType(type.get(), innerTypeName);
        }
        return type;
    }

    public static ClassOrInterfaceDeclaration demandClass(CompilationUnit cu, String qualifiedName) {
        ClassOrInterfaceDeclaration cd = Navigator.demandClassOrInterface(cu, qualifiedName);
        if (cd.isInterface()) {
            throw new IllegalStateException("Type is not a class");
        }
        return cd;
    }

    public static ClassOrInterfaceDeclaration demandInterface(CompilationUnit cu, String qualifiedName) {
        ClassOrInterfaceDeclaration cd = Navigator.demandClassOrInterface(cu, qualifiedName);
        if (!cd.isInterface()) {
            throw new IllegalStateException("Type is not an interface");
        }
        return cd;
    }

    public static EnumDeclaration demandEnum(CompilationUnit cu, String qualifiedName) {
        Optional<TypeDeclaration<?>> res = Navigator.findType(cu, qualifiedName);
        if (!res.isPresent()) {
            throw new IllegalStateException("No type found");
        }
        if (!(res.get() instanceof EnumDeclaration)) {
            throw new IllegalStateException("Type is not an enum");
        }
        return (EnumDeclaration)res.get();
    }

    public static MethodDeclaration demandMethod(TypeDeclaration<?> cd, String name) {
        MethodDeclaration found = null;
        for (BodyDeclaration bd : cd.getMembers()) {
            MethodDeclaration md;
            if (!(bd instanceof MethodDeclaration) || !(md = (MethodDeclaration)bd).getNameAsString().equals(name)) continue;
            if (found != null) {
                throw new IllegalStateException("Ambiguous getName");
            }
            found = md;
        }
        if (found == null) {
            throw new IllegalStateException("No method called " + name);
        }
        return found;
    }

    public static ConstructorDeclaration demandConstructor(TypeDeclaration<?> td, int index) {
        ConstructorDeclaration found = null;
        int i = 0;
        for (BodyDeclaration bd : td.getMembers()) {
            if (!(bd instanceof ConstructorDeclaration)) continue;
            ConstructorDeclaration cd = (ConstructorDeclaration)bd;
            if (i == index) {
                found = cd;
                break;
            }
            ++i;
        }
        if (found == null) {
            throw new IllegalStateException("No constructor with index " + index);
        }
        return found;
    }

    public static VariableDeclarator demandField(ClassOrInterfaceDeclaration cd, String name) {
        for (BodyDeclaration bd : cd.getMembers()) {
            if (!(bd instanceof FieldDeclaration)) continue;
            FieldDeclaration fd = (FieldDeclaration)bd;
            for (VariableDeclarator vd : fd.getVariables()) {
                if (!vd.getName().getId().equals(name)) continue;
                return vd;
            }
        }
        throw new IllegalStateException("No field with given name");
    }

    public static Optional<NameExpr> findNameExpression(Node node, String name) {
        return node.findFirst(NameExpr.class, n -> n.getNameAsString().equals(name));
    }

    public static Optional<SimpleName> findSimpleName(Node node, String name) {
        return node.findFirst(SimpleName.class, n -> n.asString().equals(name));
    }

    public static Optional<MethodCallExpr> findMethodCall(Node node, String methodName) {
        return node.findFirst(MethodCallExpr.class, n -> n.getNameAsString().equals(methodName));
    }

    public static Optional<VariableDeclarator> demandVariableDeclaration(Node node, String name) {
        return node.findFirst(VariableDeclarator.class, n -> n.getNameAsString().equals(name));
    }

    public static ClassOrInterfaceDeclaration demandClassOrInterface(CompilationUnit compilationUnit, String qualifiedName) {
        return Navigator.findType(compilationUnit, qualifiedName).map(res -> (ClassOrInterfaceDeclaration)res.toClassOrInterfaceDeclaration().orElseThrow(() -> new IllegalStateException("Type is not a class or an interface, it is " + res.getClass().getCanonicalName()))).orElseThrow(() -> new IllegalStateException("No type named '" + qualifiedName + "'found"));
    }

    public static SwitchStmt findSwitch(Node node) {
        return Navigator.findSwitchHelper(node).orElseThrow(IllegalArgumentException::new);
    }

    public static <N extends Node> N findNodeOfGivenClass(Node node, Class<N> clazz) {
        return (N)((Node)node.findFirst(clazz).orElseThrow(IllegalArgumentException::new));
    }

    @Deprecated
    public static <N extends Node> List<N> findAllNodesOfGivenClass(Node node, Class<N> clazz) {
        return node.findAll(clazz);
    }

    public static ReturnStmt findReturnStmt(MethodDeclaration method) {
        return Navigator.findNodeOfGivenClass((Node)method, ReturnStmt.class);
    }

    @Deprecated
    public static <N extends Node> Optional<N> findAncestor(Node node, Class<N> clazz) {
        return node.findAncestor(clazz);
    }

    private static String getOuterTypeName(String qualifiedName) {
        return qualifiedName.split("\\.", 2)[0];
    }

    private static String getInnerTypeName(String qualifiedName) {
        if (qualifiedName.contains(".")) {
            return qualifiedName.split("\\.", 2)[1];
        }
        return "";
    }

    private static Optional<SwitchStmt> findSwitchHelper(Node node) {
        if (node instanceof SwitchStmt) {
            return Optional.of((SwitchStmt)node);
        }
        for (Node child : node.getChildNodes()) {
            Optional<SwitchStmt> resChild = Navigator.findSwitchHelper(child);
            if (!resChild.isPresent()) continue;
            return resChild;
        }
        return Optional.empty();
    }
}

