/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import java.io.Serializable;
import java.util.function.ToDoubleBiFunction;
import java.util.stream.IntStream;
import smile.math.blas.UPLO;
import smile.math.matrix.Matrix;

public interface MercerKernel<T>
extends ToDoubleBiFunction<T, T>,
Serializable {
    public double k(T var1, T var2);

    public double[] kg(T var1, T var2);

    default public double apply(T x, T y) {
        return this.k(x, y);
    }

    @Override
    default public double applyAsDouble(T x, T y) {
        return this.k(x, y);
    }

    default public Matrix[] KG(T[] x) {
        int n = x.length;
        int m = this.lo().length;
        Matrix[] K = new Matrix[m + 1];
        for (int i = 0; i <= m; ++i) {
            K[i] = new Matrix(n, n);
            K[i].uplo(UPLO.LOWER);
        }
        IntStream.range(0, n).parallel().forEach(j -> {
            Object xj = x[j];
            for (int i = 0; i < n; ++i) {
                double[] kg = this.kg(x[i], xj);
                for (int l = 0; l <= m; ++l) {
                    K[l].set(i, j, kg[l]);
                }
            }
        });
        return K;
    }

    default public Matrix K(T[] x) {
        int n = x.length;
        Matrix K = new Matrix(n, n);
        IntStream.range(0, n).parallel().forEach(j -> {
            Object xj = x[j];
            for (int i = 0; i < n; ++i) {
                K.set(i, j, this.k(x[i], xj));
            }
        });
        K.uplo(UPLO.LOWER);
        return K;
    }

    default public Matrix K(T[] x, T[] y) {
        int m = x.length;
        int n = y.length;
        Matrix K = new Matrix(m, n);
        IntStream.range(0, n).parallel().forEach(j -> {
            Object yj = y[j];
            for (int i = 0; i < m; ++i) {
                K.set(i, j, this.k(x[i], yj));
            }
        });
        return K;
    }

    public MercerKernel<T> of(double[] var1);

    public double[] hyperparameters();

    public double[] lo();

    public double[] hi();
}

