/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.util.Arrays;
import smile.math.Complex;
import smile.math.MathEx;
import smile.math.matrix.Cholesky;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.LU;
import smile.math.matrix.Matrix;
import smile.math.matrix.QR;
import smile.math.matrix.SVD;

public class JMatrix
implements DenseMatrix {
    private static final long serialVersionUID = 1L;
    private double[] A;
    private int nrows;
    private int ncols;
    private boolean symmetric = false;

    public JMatrix(double[][] A) {
        this.nrows = A.length;
        this.ncols = A[0].length;
        this.A = new double[this.nrows * this.ncols];
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                this.set(i, j, A[i][j]);
            }
        }
    }

    public JMatrix(double[] A) {
        this.nrows = A.length;
        this.ncols = 1;
        this.A = A;
    }

    public JMatrix(int rows, int cols) {
        this.nrows = rows;
        this.ncols = cols;
        this.A = new double[rows * cols];
    }

    public JMatrix(int rows, int cols, double value) {
        this(rows, cols);
        Arrays.fill(this.A, value);
    }

    public JMatrix(int rows, int cols, double[] value) {
        this.nrows = rows;
        this.ncols = cols;
        this.A = value;
    }

    @Override
    public boolean isSymmetric() {
        return this.symmetric;
    }

    @Override
    public void setSymmetric(boolean symmetric) {
        this.symmetric = symmetric;
    }

    @Override
    public JMatrix copy() {
        JMatrix a = new JMatrix(this.nrows, this.ncols, (double[])this.A.clone());
        a.setSymmetric(this.isSymmetric());
        return a;
    }

    @Override
    public double[] data() {
        return this.A;
    }

    @Override
    public void fill(double x) {
        Arrays.fill(this.A, x);
    }

    @Override
    public JMatrix transpose() {
        JMatrix B = new JMatrix(this.ncols(), this.nrows());
        for (int i = 0; i < this.nrows(); ++i) {
            for (int j = 0; j < this.ncols(); ++j) {
                B.set(j, i, this.get(i, j));
            }
        }
        return B;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public int nrows() {
        return this.nrows;
    }

    @Override
    public int ncols() {
        return this.ncols;
    }

    @Override
    public double get(int i, int j) {
        return this.A[j * this.nrows + i];
    }

    @Override
    public double set(int i, int j, double x) {
        double d = x;
        this.A[j * this.nrows + i] = d;
        return d;
    }

    @Override
    public double add(int i, int j, double x) {
        int n = j * this.nrows + i;
        double d = this.A[n] + x;
        this.A[n] = d;
        return d;
    }

    @Override
    public double sub(int i, int j, double x) {
        int n = j * this.nrows + i;
        double d = this.A[n] - x;
        this.A[n] = d;
        return d;
    }

    @Override
    public double mul(int i, int j, double x) {
        int n = j * this.nrows + i;
        double d = this.A[n] * x;
        this.A[n] = d;
        return d;
    }

    @Override
    public double div(int i, int j, double x) {
        int n = j * this.nrows + i;
        double d = this.A[n] / x;
        this.A[n] = d;
        return d;
    }

    @Override
    public JMatrix add(DenseMatrix b) {
        if (b instanceof JMatrix) {
            return this.add((JMatrix)b);
        }
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                this.add(i, j, b.get(i, j));
            }
        }
        return this;
    }

    public JMatrix add(JMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] + b.A[i];
        }
        return this;
    }

    @Override
    public DenseMatrix add(DenseMatrix b, DenseMatrix c) {
        if (b instanceof JMatrix && c instanceof JMatrix) {
            return this.add((JMatrix)b, (JMatrix)c);
        }
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                c.set(i, j, this.get(i, j) + b.get(i, j));
            }
        }
        return c;
    }

    public JMatrix add(JMatrix b, JMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            c.A[i] = this.A[i] + b.A[i];
        }
        return c;
    }

    @Override
    public JMatrix sub(DenseMatrix b) {
        if (b instanceof JMatrix) {
            return this.sub((JMatrix)b);
        }
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                this.sub(i, j, b.get(i, j));
            }
        }
        return this;
    }

    public JMatrix sub(JMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] - b.A[i];
        }
        return this;
    }

    @Override
    public DenseMatrix sub(DenseMatrix b, DenseMatrix c) {
        if (b instanceof JMatrix && c instanceof JMatrix) {
            return this.sub((JMatrix)b, (JMatrix)c);
        }
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                c.set(i, j, this.get(i, j) - b.get(i, j));
            }
        }
        return c;
    }

    public JMatrix sub(JMatrix b, JMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            c.A[i] = this.A[i] - b.A[i];
        }
        return c;
    }

    @Override
    public JMatrix mul(DenseMatrix b) {
        if (b instanceof JMatrix) {
            return this.mul((JMatrix)b);
        }
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                this.mul(i, j, b.get(i, j));
            }
        }
        return this;
    }

    public JMatrix mul(JMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] * b.A[i];
        }
        return this;
    }

    @Override
    public DenseMatrix mul(DenseMatrix b, DenseMatrix c) {
        if (b instanceof JMatrix && c instanceof JMatrix) {
            return this.mul((JMatrix)b, (JMatrix)c);
        }
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                c.set(i, j, this.get(i, j) * b.get(i, j));
            }
        }
        return c;
    }

    public JMatrix mul(JMatrix b, JMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            c.A[i] = this.A[i] * b.A[i];
        }
        return c;
    }

    @Override
    public JMatrix div(DenseMatrix b) {
        if (b instanceof JMatrix) {
            return this.div((JMatrix)b);
        }
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                this.div(i, j, b.get(i, j));
            }
        }
        return this;
    }

    public JMatrix div(JMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] / b.A[i];
        }
        return this;
    }

    @Override
    public DenseMatrix div(DenseMatrix b, DenseMatrix c) {
        if (b instanceof JMatrix && c instanceof JMatrix) {
            return this.div((JMatrix)b, (JMatrix)c);
        }
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                c.set(i, j, this.get(i, j) / b.get(i, j));
            }
        }
        return c;
    }

    public JMatrix div(JMatrix b, JMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            c.A[i] = this.A[i] / b.A[i];
        }
        return c;
    }

    @Override
    public JMatrix add(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] + x;
        }
        return this;
    }

    @Override
    public DenseMatrix add(double x, DenseMatrix c) {
        if (c instanceof JMatrix) {
            return this.add(x, (JMatrix)c);
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int j = 0; j < this.ncols; ++j) {
            for (int i = 0; i < this.nrows; ++i) {
                c.set(i, j, this.get(i, j) + x);
            }
        }
        return c;
    }

    public JMatrix add(double x, JMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            c.A[i] = this.A[i] + x;
        }
        return c;
    }

    @Override
    public JMatrix sub(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] - x;
        }
        return this;
    }

    @Override
    public DenseMatrix sub(double x, DenseMatrix c) {
        if (c instanceof JMatrix) {
            return this.sub(x, (JMatrix)c);
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int j = 0; j < this.ncols; ++j) {
            for (int i = 0; i < this.nrows; ++i) {
                c.set(i, j, this.get(i, j) - x);
            }
        }
        return c;
    }

    public JMatrix sub(double x, JMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            c.A[i] = this.A[i] - x;
        }
        return c;
    }

    @Override
    public JMatrix mul(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] * x;
        }
        return this;
    }

    @Override
    public DenseMatrix mul(double x, DenseMatrix c) {
        if (c instanceof JMatrix) {
            return this.mul(x, (JMatrix)c);
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int j = 0; j < this.ncols; ++j) {
            for (int i = 0; i < this.nrows; ++i) {
                c.set(i, j, this.get(i, j) * x);
            }
        }
        return c;
    }

    public JMatrix mul(double x, JMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            c.A[i] = this.A[i] * x;
        }
        return c;
    }

    @Override
    public JMatrix div(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] / x;
        }
        return this;
    }

    @Override
    public DenseMatrix div(double x, DenseMatrix c) {
        if (c instanceof JMatrix) {
            return this.div(x, (JMatrix)c);
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int j = 0; j < this.ncols; ++j) {
            for (int i = 0; i < this.nrows; ++i) {
                c.set(i, j, this.get(i, j) / x);
            }
        }
        return c;
    }

    public JMatrix div(double x, JMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            c.A[i] = this.A[i] / x;
        }
        return c;
    }

    @Override
    public JMatrix replaceNaN(double x) {
        for (int i = 0; i < this.A.length; ++i) {
            if (!Double.isNaN(this.A[i])) continue;
            this.A[i] = x;
        }
        return this;
    }

    @Override
    public double sum() {
        double s = 0.0;
        for (int i = 0; i < this.A.length; ++i) {
            s += this.A[i];
        }
        return s;
    }

    @Override
    public JMatrix ata() {
        JMatrix C = new JMatrix(this.ncols, this.ncols);
        for (int i = 0; i < this.ncols; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                double v = 0.0;
                for (int k = 0; k < this.nrows; ++k) {
                    v += this.get(k, i) * this.get(k, j);
                }
                C.set(i, j, v);
            }
        }
        return C;
    }

    @Override
    public JMatrix aat() {
        JMatrix C = new JMatrix(this.nrows, this.nrows);
        for (int k = 0; k < this.ncols; ++k) {
            for (int i = 0; i < this.nrows; ++i) {
                for (int j = 0; j < this.nrows; ++j) {
                    C.add(i, j, this.get(i, k) * this.get(j, k));
                }
            }
        }
        return C;
    }

    @Override
    public double[] ax(double[] x, double[] y) {
        int n = Math.min(this.nrows, y.length);
        int p = Math.min(this.ncols, x.length);
        Arrays.fill(y, 0, n, 0.0);
        for (int k = 0; k < p; ++k) {
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                y[n2] = y[n2] + this.get(i, k) * x[k];
            }
        }
        return y;
    }

    @Override
    public double[] axpy(double[] x, double[] y) {
        int n = Math.min(this.nrows, y.length);
        int p = Math.min(this.ncols, x.length);
        for (int k = 0; k < p; ++k) {
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                y[n2] = y[n2] + this.get(i, k) * x[k];
            }
        }
        return y;
    }

    @Override
    public double[] axpy(double[] x, double[] y, double b) {
        int n = Math.min(this.nrows, y.length);
        int p = Math.min(this.ncols, x.length);
        int i = 0;
        while (i < n) {
            int n2 = i++;
            y[n2] = y[n2] * b;
        }
        for (int k = 0; k < p; ++k) {
            for (int i2 = 0; i2 < n; ++i2) {
                int n3 = i2;
                y[n3] = y[n3] + this.get(i2, k) * x[k];
            }
        }
        return y;
    }

    @Override
    public double[] atx(double[] x, double[] y) {
        int n = Math.min(this.ncols, y.length);
        int p = Math.min(this.nrows, x.length);
        Arrays.fill(y, 0, n, 0.0);
        for (int i = 0; i < n; ++i) {
            for (int k = 0; k < p; ++k) {
                int n2 = i;
                y[n2] = y[n2] + this.get(k, i) * x[k];
            }
        }
        return y;
    }

    @Override
    public double[] atxpy(double[] x, double[] y) {
        int n = Math.min(this.ncols, y.length);
        int p = Math.min(this.nrows, x.length);
        for (int i = 0; i < n; ++i) {
            for (int k = 0; k < p; ++k) {
                int n2 = i;
                y[n2] = y[n2] + this.get(k, i) * x[k];
            }
        }
        return y;
    }

    @Override
    public double[] atxpy(double[] x, double[] y, double b) {
        int n = Math.min(this.ncols, y.length);
        int p = Math.min(this.nrows, x.length);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            y[n2] = y[n2] * b;
            for (int k = 0; k < p; ++k) {
                int n3 = i;
                y[n3] = y[n3] + this.get(k, i) * x[k];
            }
        }
        return y;
    }

    @Override
    public JMatrix abmm(DenseMatrix B) {
        if (this.ncols() != B.nrows()) {
            throw new IllegalArgumentException(String.format("Matrix multiplication A * B: %d x %d vs %d x %d", this.nrows(), this.ncols(), B.nrows(), B.ncols()));
        }
        JMatrix C = new JMatrix(this.nrows, B.ncols());
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < B.ncols(); ++j) {
                double v = 0.0;
                for (int k = 0; k < this.ncols; ++k) {
                    v += this.get(i, k) * B.get(k, j);
                }
                C.set(i, j, v);
            }
        }
        return C;
    }

    @Override
    public JMatrix abtmm(DenseMatrix B) {
        if (this.ncols() != B.ncols()) {
            throw new IllegalArgumentException(String.format("Matrix multiplication A * B': %d x %d vs %d x %d", this.nrows(), this.ncols(), B.nrows(), B.ncols()));
        }
        JMatrix C = new JMatrix(this.nrows, B.nrows());
        for (int k = 0; k < this.ncols; ++k) {
            for (int i = 0; i < this.nrows; ++i) {
                for (int j = 0; j < B.nrows(); ++j) {
                    C.add(i, j, this.get(i, k) * B.get(j, k));
                }
            }
        }
        return C;
    }

    @Override
    public JMatrix atbmm(DenseMatrix B) {
        if (this.nrows() != B.nrows()) {
            throw new IllegalArgumentException(String.format("Matrix multiplication A' * B: %d x %d vs %d x %d", this.nrows(), this.ncols(), B.nrows(), B.ncols()));
        }
        JMatrix C = new JMatrix(this.ncols, B.ncols());
        for (int i = 0; i < this.ncols; ++i) {
            for (int j = 0; j < B.ncols(); ++j) {
                double v = 0.0;
                for (int k = 0; k < this.nrows; ++k) {
                    v += this.get(k, i) * B.get(k, j);
                }
                C.set(i, j, v);
            }
        }
        return C;
    }

    @Override
    public JMatrix atbtmm(DenseMatrix B) {
        if (this.nrows() != B.ncols()) {
            throw new IllegalArgumentException(String.format("Matrix multiplication A' * B': %d x %d vs %d x %d", this.nrows(), this.ncols(), B.nrows(), B.ncols()));
        }
        JMatrix C = new JMatrix(this.ncols, B.nrows());
        for (int i = 0; i < this.ncols; ++i) {
            for (int j = 0; j < B.nrows(); ++j) {
                double v = 0.0;
                for (int k = 0; k < this.nrows; ++k) {
                    v += this.get(k, i) * B.get(j, k);
                }
                C.set(i, j, v);
            }
        }
        return C;
    }

    @Override
    public LU lu() {
        int m = this.nrows();
        int n = this.ncols();
        int[] piv = new int[m];
        for (int i = 0; i < m; ++i) {
            piv[i] = i;
        }
        int pivsign = 1;
        double[] LUcolj = new double[m];
        for (int j = 0; j < n; ++j) {
            int i;
            int i2;
            for (i2 = 0; i2 < m; ++i2) {
                LUcolj[i2] = this.get(i2, j);
            }
            for (i2 = 0; i2 < m; ++i2) {
                int kmax = Math.min(i2, j);
                double s = 0.0;
                for (int k = 0; k < kmax; ++k) {
                    s += this.get(i2, k) * LUcolj[k];
                }
                int n2 = i2;
                LUcolj[n2] = LUcolj[n2] - s;
                this.set(i2, j, LUcolj[i2]);
            }
            int p = j;
            for (i = j + 1; i < m; ++i) {
                if (!(Math.abs(LUcolj[i]) > Math.abs(LUcolj[p]))) continue;
                p = i;
            }
            if (p != j) {
                int k;
                for (k = 0; k < n; ++k) {
                    double t2 = this.get(p, k);
                    this.set(p, k, this.get(j, k));
                    this.set(j, k, t2);
                }
                k = piv[p];
                piv[p] = piv[j];
                piv[j] = k;
                pivsign = -pivsign;
            }
            if (!(j < m & this.get(j, j) != 0.0)) continue;
            for (i = j + 1; i < m; ++i) {
                this.div(i, j, this.get(j, j));
            }
        }
        boolean singular = false;
        for (int j = 0; j < n; ++j) {
            if (this.get(j, j) != 0.0) continue;
            singular = true;
            break;
        }
        return new LU(this, piv, pivsign, singular);
    }

    @Override
    public Cholesky cholesky() {
        if (this.nrows() != this.ncols()) {
            throw new UnsupportedOperationException("Cholesky decomposition on non-square matrix");
        }
        int n = this.nrows();
        for (int j = 0; j < n; ++j) {
            double d = 0.0;
            for (int k = 0; k < j; ++k) {
                double s = 0.0;
                for (int i = 0; i < k; ++i) {
                    s += this.get(k, i) * this.get(j, i);
                }
                s = (this.get(j, k) - s) / this.get(k, k);
                this.set(j, k, s);
                d += s * s;
            }
            d = this.get(j, j) - d;
            if (d < 0.0) {
                throw new IllegalArgumentException("The matrix is not positive definite.");
            }
            this.set(j, j, Math.sqrt(d));
        }
        return new Cholesky(this);
    }

    @Override
    public QR qr() {
        return this.qr(1.0E-7);
    }

    public QR qr(double tol) {
        int m = this.nrows();
        int n = this.ncols();
        double[] rDiagonal = new double[n];
        for (int k = 0; k < n; ++k) {
            int i;
            double nrm = 0.0;
            for (i = k; i < m; ++i) {
                nrm = Math.hypot(nrm, this.get(i, k));
            }
            if (nrm != 0.0) {
                if (this.get(k, k) < 0.0) {
                    nrm = -nrm;
                }
                for (i = k; i < m; ++i) {
                    this.div(i, k, nrm);
                }
                this.add(k, k, 1.0);
                for (int j = k + 1; j < n; ++j) {
                    int i2;
                    double s = 0.0;
                    for (i2 = k; i2 < m; ++i2) {
                        s += this.get(i2, k) * this.get(i2, j);
                    }
                    s = -s / this.get(k, k);
                    for (i2 = k; i2 < m; ++i2) {
                        this.add(i2, j, s * this.get(i2, k));
                    }
                }
            }
            rDiagonal[k] = -nrm;
        }
        boolean singular = false;
        for (int j = 0; j < rDiagonal.length; ++j) {
            if (!(Math.abs(rDiagonal[j]) < tol)) continue;
            singular = true;
            break;
        }
        return new QR(this, rDiagonal, singular);
    }

    @Override
    public SVD svd() {
        int j;
        double h;
        double f;
        int k;
        double s;
        int i;
        int m = this.nrows();
        int n = this.ncols();
        int l = 0;
        int nm = 0;
        double anorm = 0.0;
        double scale = 0.0;
        double g = 0.0;
        JMatrix U = this;
        DenseMatrix V = Matrix.zeros(n, n);
        double[] w = new double[n];
        double[] rv1 = new double[n];
        for (i = 0; i < n; ++i) {
            l = i + 2;
            rv1[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < m) {
                for (k = i; k < m; ++k) {
                    scale += Math.abs(U.get(k, i));
                }
                if (scale != 0.0) {
                    for (k = i; k < m; ++k) {
                        U.div(k, i, scale);
                        s += U.get(k, i) * U.get(k, i);
                    }
                    f = U.get(i, i);
                    g = -Math.copySign(Math.sqrt(s), f);
                    h = f * g - s;
                    U.set(i, i, f - g);
                    for (j = l - 1; j < n; ++j) {
                        s = 0.0;
                        for (k = i; k < m; ++k) {
                            s += U.get(k, i) * U.get(k, j);
                        }
                        f = s / h;
                        for (k = i; k < m; ++k) {
                            U.add(k, j, f * U.get(k, i));
                        }
                    }
                    for (k = i; k < m; ++k) {
                        U.mul(k, i, scale);
                    }
                }
            }
            w[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i + 1 <= m && i + 1 != n) {
                for (k = l - 1; k < n; ++k) {
                    scale += Math.abs(U.get(i, k));
                }
                if (scale != 0.0) {
                    for (k = l - 1; k < n; ++k) {
                        U.div(i, k, scale);
                        s += U.get(i, k) * U.get(i, k);
                    }
                    f = U.get(i, l - 1);
                    g = -Math.copySign(Math.sqrt(s), f);
                    h = f * g - s;
                    U.set(i, l - 1, f - g);
                    for (k = l - 1; k < n; ++k) {
                        rv1[k] = U.get(i, k) / h;
                    }
                    for (j = l - 1; j < m; ++j) {
                        s = 0.0;
                        for (k = l - 1; k < n; ++k) {
                            s += U.get(j, k) * U.get(i, k);
                        }
                        for (k = l - 1; k < n; ++k) {
                            U.add(j, k, s * rv1[k]);
                        }
                    }
                    for (k = l - 1; k < n; ++k) {
                        U.mul(i, k, scale);
                    }
                }
            }
            anorm = Math.max(anorm, Math.abs(w[i]) + Math.abs(rv1[i]));
        }
        i = n - 1;
        while (i >= 0) {
            if (i < n - 1) {
                if (g != 0.0) {
                    for (j = l; j < n; ++j) {
                        V.set(j, i, U.get(i, j) / U.get(i, l) / g);
                    }
                    for (j = l; j < n; ++j) {
                        s = 0.0;
                        for (k = l; k < n; ++k) {
                            s += U.get(i, k) * V.get(k, j);
                        }
                        for (k = l; k < n; ++k) {
                            V.add(k, j, s * V.get(k, i));
                        }
                    }
                }
                for (j = l; j < n; ++j) {
                    V.set(i, j, 0.0);
                    V.set(j, i, 0.0);
                }
            }
            V.set(i, i, 1.0);
            g = rv1[i];
            l = i--;
        }
        for (i = Math.min(m, n) - 1; i >= 0; --i) {
            l = i + 1;
            g = w[i];
            for (j = l; j < n; ++j) {
                U.set(i, j, 0.0);
            }
            if (g != 0.0) {
                g = 1.0 / g;
                for (j = l; j < n; ++j) {
                    s = 0.0;
                    for (k = l; k < m; ++k) {
                        s += U.get(k, i) * U.get(k, j);
                    }
                    f = s / U.get(i, i) * g;
                    for (k = i; k < m; ++k) {
                        U.add(k, j, f * U.get(k, i));
                    }
                }
                for (j = i; j < m; ++j) {
                    U.mul(j, i, g);
                }
            } else {
                for (j = i; j < m; ++j) {
                    U.set(j, i, 0.0);
                }
            }
            U.add(i, i, 1.0);
        }
        block27: for (k = n - 1; k >= 0; --k) {
            for (int its = 0; its < 30; ++its) {
                double z;
                double y;
                double c;
                boolean flag = true;
                for (l = k; l >= 0; --l) {
                    nm = l - 1;
                    if (l == 0 || Math.abs(rv1[l]) <= MathEx.EPSILON * anorm) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(w[nm]) <= MathEx.EPSILON * anorm) break;
                }
                if (flag) {
                    c = 0.0;
                    s = 1.0;
                    for (i = l; i < k + 1; ++i) {
                        f = s * rv1[i];
                        rv1[i] = c * rv1[i];
                        if (Math.abs(f) <= MathEx.EPSILON * anorm) break;
                        g = w[i];
                        w[i] = h = Math.hypot(f, g);
                        h = 1.0 / h;
                        c = g * h;
                        s = -f * h;
                        for (j = 0; j < m; ++j) {
                            y = U.get(j, nm);
                            z = U.get(j, i);
                            U.set(j, nm, y * c + z * s);
                            U.set(j, i, z * c - y * s);
                        }
                    }
                }
                z = w[k];
                if (l == k) {
                    if (!(z < 0.0)) continue block27;
                    w[k] = -z;
                    for (j = 0; j < n; ++j) {
                        V.set(j, k, -V.get(j, k));
                    }
                    continue block27;
                }
                if (its == 29) {
                    throw new IllegalStateException("no convergence in 30 iterations");
                }
                double x = w[l];
                nm = k - 1;
                y = w[nm];
                g = rv1[nm];
                h = rv1[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = Math.hypot(f, 1.0);
                f = ((x - z) * (x + z) + h * (y / (f + Math.copySign(g, f)) - h)) / x;
                s = 1.0;
                c = 1.0;
                for (j = l; j <= nm; ++j) {
                    int jj;
                    i = j + 1;
                    g = rv1[i];
                    y = w[i];
                    h = s * g;
                    g = c * g;
                    rv1[j] = z = Math.hypot(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    for (jj = 0; jj < n; ++jj) {
                        x = V.get(jj, j);
                        z = V.get(jj, i);
                        V.set(jj, j, x * c + z * s);
                        V.set(jj, i, z * c - x * s);
                    }
                    w[j] = z = Math.hypot(f, h);
                    if (z != 0.0) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    for (jj = 0; jj < m; ++jj) {
                        y = U.get(jj, j);
                        z = U.get(jj, i);
                        U.set(jj, j, y * c + z * s);
                        U.set(jj, i, z * c - y * s);
                    }
                }
                rv1[l] = 0.0;
                rv1[k] = f;
                w[k] = x;
            }
        }
        int inc = 1;
        double[] su = new double[m];
        double[] sv = new double[n];
        do {
            inc *= 3;
        } while (++inc <= n);
        do {
            for (i = inc /= 3; i < n; ++i) {
                double sw = w[i];
                for (k = 0; k < m; ++k) {
                    su[k] = U.get(k, i);
                }
                for (k = 0; k < n; ++k) {
                    sv[k] = V.get(k, i);
                }
                j = i;
                while (w[j - inc] < sw) {
                    w[j] = w[j - inc];
                    for (k = 0; k < m; ++k) {
                        U.set(k, j, U.get(k, j - inc));
                    }
                    for (k = 0; k < n; ++k) {
                        V.set(k, j, V.get(k, j - inc));
                    }
                    if ((j -= inc) >= inc) continue;
                }
                w[j] = sw;
                for (k = 0; k < m; ++k) {
                    U.set(k, j, su[k]);
                }
                for (k = 0; k < n; ++k) {
                    V.set(k, j, sv[k]);
                }
            }
        } while (inc > 1);
        for (k = 0; k < n; ++k) {
            s = 0.0;
            for (i = 0; i < m; ++i) {
                if (!(U.get(i, k) < 0.0)) continue;
                s += 1.0;
            }
            for (j = 0; j < n; ++j) {
                if (!(V.get(j, k) < 0.0)) continue;
                s += 1.0;
            }
            if (!(s > (double)((m + n) / 2))) continue;
            for (i = 0; i < m; ++i) {
                U.set(i, k, -U.get(i, k));
            }
            for (j = 0; j < n; ++j) {
                V.set(j, k, -V.get(j, k));
            }
        }
        double[] sigma = new double[Math.min(m, n)];
        System.arraycopy(w, 0, sigma, 0, sigma.length);
        return new SVD(U, V, sigma);
    }

    @Override
    public double[] eig() {
        if (this.nrows() != this.ncols()) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", this.nrows(), this.ncols()));
        }
        int n = this.nrows();
        double[] d = new double[n];
        double[] e = new double[n];
        if (this.isSymmetric()) {
            JMatrix.tred(this, d, e);
            JMatrix.tql(d, e, n);
        } else {
            double[] scale = JMatrix.balance(this);
            int[] perm = JMatrix.elmhes(this);
            JMatrix.hqr(this, d, e);
            JMatrix.sort(d, e);
        }
        double[] w = new double[2 * n];
        System.arraycopy(d, 0, w, 0, n);
        System.arraycopy(e, 0, w, n, n);
        return w;
    }

    @Override
    public EVD eigen() {
        DenseMatrix V;
        if (this.nrows() != this.ncols()) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", this.nrows(), this.ncols()));
        }
        int n = this.nrows();
        double[] d = new double[n];
        double[] e = new double[n];
        if (this.isSymmetric()) {
            V = this;
            JMatrix.tred2(V, d, e);
            JMatrix.tql2(V, d, e);
        } else {
            double[] scale = JMatrix.balance(this);
            int[] perm = JMatrix.elmhes(this);
            V = Matrix.eye(n, n);
            JMatrix.eltran(this, V, perm);
            JMatrix.hqr2(this, V, d, e);
            JMatrix.balbak(V, scale);
            JMatrix.sort(d, e, V);
        }
        return new EVD(V, d, e);
    }

    private static void tred(DenseMatrix V, double[] d, double[] e) {
        int i;
        int n = V.nrows();
        for (i = 0; i < n; ++i) {
            d[i] = V.get(n - 1, i);
        }
        for (i = n - 1; i > 0; --i) {
            int k;
            double scale = 0.0;
            double h = 0.0;
            for (k = 0; k < i; ++k) {
                scale += Math.abs(d[k]);
            }
            if (scale == 0.0) {
                e[i] = d[i - 1];
                for (int j = 0; j < i; ++j) {
                    d[j] = V.get(i - 1, j);
                    V.set(i, j, 0.0);
                    V.set(j, i, 0.0);
                }
            } else {
                int j;
                int j2;
                for (k = 0; k < i; ++k) {
                    int n2 = k;
                    d[n2] = d[n2] / scale;
                    h += d[k] * d[k];
                }
                double f = d[i - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                e[i] = scale * g;
                h -= f * g;
                d[i - 1] = f - g;
                for (j2 = 0; j2 < i; ++j2) {
                    e[j2] = 0.0;
                }
                for (j2 = 0; j2 < i; ++j2) {
                    f = d[j2];
                    V.set(j2, i, f);
                    g = e[j2] + V.get(j2, j2) * f;
                    for (int k2 = j2 + 1; k2 <= i - 1; ++k2) {
                        g += V.get(k2, j2) * d[k2];
                        int n3 = k2;
                        e[n3] = e[n3] + V.get(k2, j2) * f;
                    }
                    e[j2] = g;
                }
                f = 0.0;
                for (j2 = 0; j2 < i; ++j2) {
                    int n4 = j2;
                    e[n4] = e[n4] / h;
                    f += e[j2] * d[j2];
                }
                double hh = f / (h + h);
                for (j = 0; j < i; ++j) {
                    int n5 = j;
                    e[n5] = e[n5] - hh * d[j];
                }
                for (j = 0; j < i; ++j) {
                    f = d[j];
                    g = e[j];
                    for (int k3 = j; k3 <= i - 1; ++k3) {
                        V.sub(k3, j, f * e[k3] + g * d[k3]);
                    }
                    d[j] = V.get(i - 1, j);
                    V.set(i, j, 0.0);
                }
            }
            d[i] = h;
        }
        for (int j = 0; j < n; ++j) {
            d[j] = V.get(j, j);
        }
        e[0] = 0.0;
    }

    private static void tred2(DenseMatrix V, double[] d, double[] e) {
        int i;
        int n = V.nrows();
        for (i = 0; i < n; ++i) {
            d[i] = V.get(n - 1, i);
        }
        for (i = n - 1; i > 0; --i) {
            int k;
            double scale = 0.0;
            double h = 0.0;
            for (k = 0; k < i; ++k) {
                scale += Math.abs(d[k]);
            }
            if (scale == 0.0) {
                e[i] = d[i - 1];
                for (int j = 0; j < i; ++j) {
                    d[j] = V.get(i - 1, j);
                    V.set(i, j, 0.0);
                    V.set(j, i, 0.0);
                }
            } else {
                int j;
                int j2;
                for (k = 0; k < i; ++k) {
                    int n2 = k;
                    d[n2] = d[n2] / scale;
                    h += d[k] * d[k];
                }
                double f = d[i - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                e[i] = scale * g;
                h -= f * g;
                d[i - 1] = f - g;
                for (j2 = 0; j2 < i; ++j2) {
                    e[j2] = 0.0;
                }
                for (j2 = 0; j2 < i; ++j2) {
                    f = d[j2];
                    V.set(j2, i, f);
                    g = e[j2] + V.get(j2, j2) * f;
                    for (int k2 = j2 + 1; k2 <= i - 1; ++k2) {
                        g += V.get(k2, j2) * d[k2];
                        int n3 = k2;
                        e[n3] = e[n3] + V.get(k2, j2) * f;
                    }
                    e[j2] = g;
                }
                f = 0.0;
                for (j2 = 0; j2 < i; ++j2) {
                    int n4 = j2;
                    e[n4] = e[n4] / h;
                    f += e[j2] * d[j2];
                }
                double hh = f / (h + h);
                for (j = 0; j < i; ++j) {
                    int n5 = j;
                    e[n5] = e[n5] - hh * d[j];
                }
                for (j = 0; j < i; ++j) {
                    f = d[j];
                    g = e[j];
                    for (int k3 = j; k3 <= i - 1; ++k3) {
                        V.sub(k3, j, f * e[k3] + g * d[k3]);
                    }
                    d[j] = V.get(i - 1, j);
                    V.set(i, j, 0.0);
                }
            }
            d[i] = h;
        }
        for (i = 0; i < n - 1; ++i) {
            int k;
            V.set(n - 1, i, V.get(i, i));
            V.set(i, i, 1.0);
            double h = d[i + 1];
            if (h != 0.0) {
                for (k = 0; k <= i; ++k) {
                    d[k] = V.get(k, i + 1) / h;
                }
                for (int j = 0; j <= i; ++j) {
                    int k4;
                    double g = 0.0;
                    for (k4 = 0; k4 <= i; ++k4) {
                        g += V.get(k4, i + 1) * V.get(k4, j);
                    }
                    for (k4 = 0; k4 <= i; ++k4) {
                        V.sub(k4, j, g * d[k4]);
                    }
                }
            }
            for (k = 0; k <= i; ++k) {
                V.set(k, i + 1, 0.0);
            }
        }
        for (int j = 0; j < n; ++j) {
            d[j] = V.get(n - 1, j);
            V.set(n - 1, j, 0.0);
        }
        V.set(n - 1, n - 1, 1.0);
        e[0] = 0.0;
    }

    private static void tql(double[] d, double[] e, int n) {
        for (int i = 1; i < n; ++i) {
            e[i - 1] = e[i];
        }
        e[n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        for (int l = 0; l < n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(d[l]) + Math.abs(e[l]));
            for (m = l; m < n && !(Math.abs(e[m]) <= MathEx.EPSILON * tst1); ++m) {
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    if (++iter >= 30) {
                        throw new RuntimeException("Too many iterations");
                    }
                    double g = d[l];
                    double p = (d[l + 1] - d[l]) / (2.0 * e[l]);
                    double r = Math.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    d[l] = e[l] / (p + r);
                    d[l + 1] = e[l] * (p + r);
                    double dl1 = d[l + 1];
                    double h = g - d[l];
                    int i = l + 2;
                    while (i < n) {
                        int n2 = i++;
                        d[n2] = d[n2] - h;
                    }
                    f += h;
                    p = d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * e[i2];
                        h = c * p;
                        r = Math.hypot(p, e[i2]);
                        e[i2 + 1] = s * r;
                        s = e[i2] / r;
                        c = p / r;
                        p = c * d[i2] - s * g;
                        d[i2 + 1] = h + s * (c * g + s * d[i2]);
                    }
                    p = -s * s2 * c3 * el1 * e[l] / dl1;
                    e[l] = s * p;
                    d[l] = c * p;
                } while (Math.abs(e[l]) > MathEx.EPSILON * tst1);
            }
            d[l] = d[l] + f;
            e[l] = 0.0;
        }
        for (int i = 0; i < n - 1; ++i) {
            int k = i;
            double p = d[i];
            for (int j = i + 1; j < n; ++j) {
                if (!(d[j] > p)) continue;
                k = j;
                p = d[j];
            }
            if (k == i) continue;
            d[k] = d[i];
            d[i] = p;
        }
    }

    static void tql2(DenseMatrix V, double[] d, double[] e) {
        int n = V.nrows();
        for (int i = 1; i < n; ++i) {
            e[i - 1] = e[i];
        }
        e[n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        for (int l = 0; l < n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(d[l]) + Math.abs(e[l]));
            for (m = l; m < n && !(Math.abs(e[m]) <= MathEx.EPSILON * tst1); ++m) {
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    if (++iter >= 30) {
                        throw new RuntimeException("Too many iterations");
                    }
                    double g = d[l];
                    double p = (d[l + 1] - g) / (2.0 * e[l]);
                    double r = Math.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    d[l] = e[l] / (p + r);
                    d[l + 1] = e[l] * (p + r);
                    double dl1 = d[l + 1];
                    double h = g - d[l];
                    int i = l + 2;
                    while (i < n) {
                        int n2 = i++;
                        d[n2] = d[n2] - h;
                    }
                    f += h;
                    p = d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * e[i2];
                        h = c * p;
                        r = Math.hypot(p, e[i2]);
                        e[i2 + 1] = s * r;
                        s = e[i2] / r;
                        c = p / r;
                        p = c * d[i2] - s * g;
                        d[i2 + 1] = h + s * (c * g + s * d[i2]);
                        for (int k = 0; k < n; ++k) {
                            h = V.get(k, i2 + 1);
                            V.set(k, i2 + 1, s * V.get(k, i2) + c * h);
                            V.set(k, i2, c * V.get(k, i2) - s * h);
                        }
                    }
                    p = -s * s2 * c3 * el1 * e[l] / dl1;
                    e[l] = s * p;
                    d[l] = c * p;
                } while (Math.abs(e[l]) > MathEx.EPSILON * tst1);
            }
            d[l] = d[l] + f;
            e[l] = 0.0;
        }
        for (int i = 0; i < n - 1; ++i) {
            int j;
            int k = i;
            double p = d[i];
            for (j = i + 1; j < n; ++j) {
                if (!(d[j] > p)) continue;
                k = j;
                p = d[j];
            }
            if (k == i) continue;
            d[k] = d[i];
            d[i] = p;
            for (j = 0; j < n; ++j) {
                p = V.get(j, i);
                V.set(j, i, V.get(j, k));
                V.set(j, k, p);
            }
        }
    }

    private static double[] balance(DenseMatrix A) {
        double sqrdx = MathEx.RADIX * MathEx.RADIX;
        int n = A.nrows();
        double[] scale = new double[n];
        for (int i = 0; i < n; ++i) {
            scale[i] = 1.0;
        }
        boolean done = false;
        while (!done) {
            done = true;
            for (int i = 0; i < n; ++i) {
                int j;
                double r = 0.0;
                double c = 0.0;
                for (int j2 = 0; j2 < n; ++j2) {
                    if (j2 == i) continue;
                    c += Math.abs(A.get(j2, i));
                    r += Math.abs(A.get(i, j2));
                }
                if (c == 0.0 || r == 0.0) continue;
                double g = r / (double)MathEx.RADIX;
                double f = 1.0;
                double s = c + r;
                while (c < g) {
                    f *= (double)MathEx.RADIX;
                    c *= sqrdx;
                }
                g = r * (double)MathEx.RADIX;
                while (c > g) {
                    f /= (double)MathEx.RADIX;
                    c /= sqrdx;
                }
                if (!((c + r) / f < 0.95 * s)) continue;
                done = false;
                g = 1.0 / f;
                int n2 = i;
                scale[n2] = scale[n2] * f;
                for (j = 0; j < n; ++j) {
                    A.mul(i, j, g);
                }
                for (j = 0; j < n; ++j) {
                    A.mul(j, i, f);
                }
            }
        }
        return scale;
    }

    private static void balbak(DenseMatrix V, double[] scale) {
        int n = V.nrows();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                V.mul(i, j, scale[i]);
            }
        }
    }

    private static int[] elmhes(DenseMatrix A) {
        int n = A.nrows();
        int[] perm = new int[n];
        for (int m = 1; m < n - 1; ++m) {
            int j;
            double x = 0.0;
            int i = m;
            for (j = m; j < n; ++j) {
                if (!(Math.abs(A.get(j, m - 1)) > Math.abs(x))) continue;
                x = A.get(j, m - 1);
                i = j;
            }
            perm[m] = i;
            if (i != m) {
                double swap;
                for (j = m - 1; j < n; ++j) {
                    swap = A.get(i, j);
                    A.set(i, j, A.get(m, j));
                    A.set(m, j, swap);
                }
                for (j = 0; j < n; ++j) {
                    swap = A.get(j, i);
                    A.set(j, i, A.get(j, m));
                    A.set(j, m, swap);
                }
            }
            if (x == 0.0) continue;
            for (i = m + 1; i < n; ++i) {
                int j2;
                double y = A.get(i, m - 1);
                if (y == 0.0) continue;
                A.set(i, m - 1, y /= x);
                for (j2 = m; j2 < n; ++j2) {
                    A.sub(i, j2, y * A.get(m, j2));
                }
                for (j2 = 0; j2 < n; ++j2) {
                    A.add(j2, m, y * A.get(j2, i));
                }
            }
        }
        return perm;
    }

    private static void eltran(DenseMatrix A, DenseMatrix V, int[] perm) {
        int n = A.nrows();
        for (int mp = n - 2; mp > 0; --mp) {
            for (int k = mp + 1; k < n; ++k) {
                V.set(k, mp, A.get(k, mp - 1));
            }
            int i = perm[mp];
            if (i == mp) continue;
            for (int j = mp; j < n; ++j) {
                V.set(mp, j, V.get(i, j));
                V.set(i, j, 0.0);
            }
            V.set(i, mp, 1.0);
        }
    }

    private static void hqr(DenseMatrix A, double[] d, double[] e) {
        int j;
        int i;
        int n = A.nrows();
        double r = 0.0;
        double q = 0.0;
        double p = 0.0;
        double anorm = 0.0;
        for (i = 0; i < n; ++i) {
            for (j = Math.max(i - 1, 0); j < n; ++j) {
                anorm += Math.abs(A.get(i, j));
            }
        }
        int nn = n - 1;
        double t2 = 0.0;
        while (nn >= 0) {
            int l;
            int its = 0;
            do {
                int m;
                double z;
                double s;
                for (l = nn; l > 0; --l) {
                    s = Math.abs(A.get(l - 1, l - 1) + Math.abs(A.get(l, l)));
                    if (s == 0.0) {
                        s = anorm;
                    }
                    if (!(Math.abs(A.get(l, l - 1)) <= MathEx.EPSILON * s)) continue;
                    A.set(l, l - 1, 0.0);
                    break;
                }
                double x = A.get(nn, nn);
                if (l == nn) {
                    d[nn--] = x + t2;
                    continue;
                }
                double y = A.get(nn - 1, nn - 1);
                double w = A.get(nn, nn - 1) * A.get(nn - 1, nn);
                if (l == nn - 1) {
                    p = 0.5 * (y - x);
                    q = p * p + w;
                    z = Math.sqrt(Math.abs(q));
                    x += t2;
                    if (q >= 0.0) {
                        z = p + Math.copySign(z, p);
                        d[nn - 1] = d[nn] = x + z;
                        if (z != 0.0) {
                            d[nn] = x - w / z;
                        }
                    } else {
                        d[nn] = x + p;
                        e[nn] = -z;
                        d[nn - 1] = d[nn];
                        e[nn - 1] = -e[nn];
                    }
                    nn -= 2;
                    continue;
                }
                if (its == 30) {
                    throw new IllegalStateException("Too many iterations in hqr");
                }
                if (its == 10 || its == 20) {
                    t2 += x;
                    for (i = 0; i < nn + 1; ++i) {
                        A.sub(i, i, x);
                    }
                    s = Math.abs(A.get(nn, nn - 1)) + Math.abs(A.get(nn - 1, nn - 2));
                    y = x = 0.75 * s;
                    w = -0.4375 * s * s;
                }
                ++its;
                for (m = nn - 2; m >= l; --m) {
                    double v;
                    double u;
                    z = A.get(m, m);
                    r = x - z;
                    s = y - z;
                    p = (r * s - w) / A.get(m + 1, m) + A.get(m, m + 1);
                    q = A.get(m + 1, m + 1) - z - r - s;
                    r = A.get(m + 2, m + 1);
                    s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (m == l || (u = Math.abs(A.get(m, m - 1)) * (Math.abs(q /= s) + Math.abs(r /= s))) <= MathEx.EPSILON * (v = Math.abs(p /= s) * (Math.abs(A.get(m - 1, m - 1)) + Math.abs(z) + Math.abs(A.get(m + 1, m + 1))))) break;
                }
                for (i = m; i < nn - 1; ++i) {
                    A.set(i + 2, i, 0.0);
                    if (i == m) continue;
                    A.set(i + 2, i - 1, 0.0);
                }
                for (int k = m; k < nn; ++k) {
                    if (k != m) {
                        p = A.get(k, k - 1);
                        q = A.get(k + 1, k - 1);
                        r = 0.0;
                        if (k + 1 != nn) {
                            r = A.get(k + 2, k - 1);
                        }
                        if ((x = Math.abs(p) + Math.abs(q) + Math.abs(r)) != 0.0) {
                            p /= x;
                            q /= x;
                            r /= x;
                        }
                    }
                    if ((s = Math.copySign(Math.sqrt(p * p + q * q + r * r), p)) == 0.0) continue;
                    if (k == m) {
                        if (l != m) {
                            A.set(k, k - 1, -A.get(k, k - 1));
                        }
                    } else {
                        A.set(k, k - 1, -s * x);
                    }
                    x = (p += s) / s;
                    y = q / s;
                    z = r / s;
                    q /= p;
                    r /= p;
                    for (j = k; j < nn + 1; ++j) {
                        p = A.get(k, j) + q * A.get(k + 1, j);
                        if (k + 1 != nn) {
                            A.sub(k + 2, j, (p += r * A.get(k + 2, j)) * z);
                        }
                        A.sub(k + 1, j, p * y);
                        A.sub(k, j, p * x);
                    }
                    int mmin = nn < k + 3 ? nn : k + 3;
                    for (i = l; i < mmin + 1; ++i) {
                        p = x * A.get(i, k) + y * A.get(i, k + 1);
                        if (k + 1 != nn) {
                            A.sub(i, k + 2, (p += z * A.get(i, k + 2)) * r);
                        }
                        A.sub(i, k + 1, p * q);
                        A.sub(i, k, p);
                    }
                }
            } while (l + 1 < nn);
        }
    }

    private static void hqr2(DenseMatrix A, DenseMatrix V, double[] d, double[] e) {
        int k;
        int m;
        double w;
        double y;
        double x;
        int j;
        int i;
        int n = A.nrows();
        double z = 0.0;
        double s = 0.0;
        double r = 0.0;
        double q = 0.0;
        double p = 0.0;
        double anorm = 0.0;
        for (i = 0; i < n; ++i) {
            for (j = Math.max(i - 1, 0); j < n; ++j) {
                anorm += Math.abs(A.get(i, j));
            }
        }
        int nn = n - 1;
        double t2 = 0.0;
        while (nn >= 0) {
            int l;
            int its = 0;
            do {
                for (l = nn; l > 0; --l) {
                    s = Math.abs(A.get(l - 1, l - 1)) + Math.abs(A.get(l, l));
                    if (s == 0.0) {
                        s = anorm;
                    }
                    if (!(Math.abs(A.get(l, l - 1)) <= MathEx.EPSILON * s)) continue;
                    A.set(l, l - 1, 0.0);
                    break;
                }
                x = A.get(nn, nn);
                if (l == nn) {
                    d[nn] = x + t2;
                    A.set(nn, nn, x + t2);
                    --nn;
                    continue;
                }
                y = A.get(nn - 1, nn - 1);
                w = A.get(nn, nn - 1) * A.get(nn - 1, nn);
                if (l == nn - 1) {
                    p = 0.5 * (y - x);
                    q = p * p + w;
                    z = Math.sqrt(Math.abs(q));
                    A.set(nn, nn, x += t2);
                    A.set(nn - 1, nn - 1, y + t2);
                    if (q >= 0.0) {
                        z = p + Math.copySign(z, p);
                        d[nn - 1] = d[nn] = x + z;
                        if (z != 0.0) {
                            d[nn] = x - w / z;
                        }
                        x = A.get(nn, nn - 1);
                        s = Math.abs(x) + Math.abs(z);
                        p = x / s;
                        q = z / s;
                        r = Math.sqrt(p * p + q * q);
                        p /= r;
                        q /= r;
                        for (j = nn - 1; j < n; ++j) {
                            z = A.get(nn - 1, j);
                            A.set(nn - 1, j, q * z + p * A.get(nn, j));
                            A.set(nn, j, q * A.get(nn, j) - p * z);
                        }
                        for (i = 0; i <= nn; ++i) {
                            z = A.get(i, nn - 1);
                            A.set(i, nn - 1, q * z + p * A.get(i, nn));
                            A.set(i, nn, q * A.get(i, nn) - p * z);
                        }
                        for (i = 0; i < n; ++i) {
                            z = V.get(i, nn - 1);
                            V.set(i, nn - 1, q * z + p * V.get(i, nn));
                            V.set(i, nn, q * V.get(i, nn) - p * z);
                        }
                    } else {
                        d[nn] = x + p;
                        e[nn] = -z;
                        d[nn - 1] = d[nn];
                        e[nn - 1] = -e[nn];
                    }
                    nn -= 2;
                    continue;
                }
                if (its == 30) {
                    throw new IllegalArgumentException("Too many iterations in hqr");
                }
                if (its == 10 || its == 20) {
                    t2 += x;
                    for (i = 0; i < nn + 1; ++i) {
                        A.sub(i, i, x);
                    }
                    s = Math.abs(A.get(nn, nn - 1)) + Math.abs(A.get(nn - 1, nn - 2));
                    y = x = 0.75 * s;
                    w = -0.4375 * s * s;
                }
                ++its;
                for (m = nn - 2; m >= l; --m) {
                    double v;
                    double u;
                    z = A.get(m, m);
                    r = x - z;
                    s = y - z;
                    p = (r * s - w) / A.get(m + 1, m) + A.get(m, m + 1);
                    q = A.get(m + 1, m + 1) - z - r - s;
                    r = A.get(m + 2, m + 1);
                    s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (m == l || (u = Math.abs(A.get(m, m - 1)) * (Math.abs(q /= s) + Math.abs(r /= s))) <= MathEx.EPSILON * (v = Math.abs(p /= s) * (Math.abs(A.get(m - 1, m - 1)) + Math.abs(z) + Math.abs(A.get(m + 1, m + 1))))) break;
                }
                for (i = m; i < nn - 1; ++i) {
                    A.set(i + 2, i, 0.0);
                    if (i == m) continue;
                    A.set(i + 2, i - 1, 0.0);
                }
                for (k = m; k < nn; ++k) {
                    if (k != m) {
                        p = A.get(k, k - 1);
                        q = A.get(k + 1, k - 1);
                        r = 0.0;
                        if (k + 1 != nn) {
                            r = A.get(k + 2, k - 1);
                        }
                        if ((x = Math.abs(p) + Math.abs(q) + Math.abs(r)) != 0.0) {
                            p /= x;
                            q /= x;
                            r /= x;
                        }
                    }
                    if ((s = Math.copySign(Math.sqrt(p * p + q * q + r * r), p)) == 0.0) continue;
                    if (k == m) {
                        if (l != m) {
                            A.set(k, k - 1, -A.get(k, k - 1));
                        }
                    } else {
                        A.set(k, k - 1, -s * x);
                    }
                    x = (p += s) / s;
                    y = q / s;
                    z = r / s;
                    q /= p;
                    r /= p;
                    for (j = k; j < n; ++j) {
                        p = A.get(k, j) + q * A.get(k + 1, j);
                        if (k + 1 != nn) {
                            A.sub(k + 2, j, (p += r * A.get(k + 2, j)) * z);
                        }
                        A.sub(k + 1, j, p * y);
                        A.sub(k, j, p * x);
                    }
                    int mmin = nn < k + 3 ? nn : k + 3;
                    for (i = 0; i < mmin + 1; ++i) {
                        p = x * A.get(i, k) + y * A.get(i, k + 1);
                        if (k + 1 != nn) {
                            A.sub(i, k + 2, (p += z * A.get(i, k + 2)) * r);
                        }
                        A.sub(i, k + 1, p * q);
                        A.sub(i, k, p);
                    }
                    for (i = 0; i < n; ++i) {
                        p = x * V.get(i, k) + y * V.get(i, k + 1);
                        if (k + 1 != nn) {
                            V.sub(i, k + 2, (p += z * V.get(i, k + 2)) * r);
                        }
                        V.sub(i, k + 1, p * q);
                        V.sub(i, k, p);
                    }
                }
            } while (l + 1 < nn);
        }
        if (anorm != 0.0) {
            for (nn = n - 1; nn >= 0; --nn) {
                Complex temp;
                p = d[nn];
                q = e[nn];
                int na = nn - 1;
                if (q == 0.0) {
                    m = nn;
                    A.set(nn, nn, 1.0);
                    for (i = nn - 1; i >= 0; --i) {
                        w = A.get(i, i) - p;
                        r = 0.0;
                        for (j = m; j <= nn; ++j) {
                            r += A.get(i, j) * A.get(j, nn);
                        }
                        if (e[i] < 0.0) {
                            z = w;
                            s = r;
                            continue;
                        }
                        m = i;
                        if (e[i] == 0.0) {
                            t2 = w;
                            if (t2 == 0.0) {
                                t2 = MathEx.EPSILON * anorm;
                            }
                            A.set(i, nn, -r / t2);
                        } else {
                            x = A.get(i, i + 1);
                            y = A.get(i + 1, i);
                            q = MathEx.sqr(d[i] - p) + MathEx.sqr(e[i]);
                            t2 = (x * s - z * r) / q;
                            A.set(i, nn, t2);
                            if (Math.abs(x) > Math.abs(z)) {
                                A.set(i + 1, nn, (-r - w * t2) / x);
                            } else {
                                A.set(i + 1, nn, (-s - y * t2) / z);
                            }
                        }
                        t2 = Math.abs(A.get(i, nn));
                        if (!(MathEx.EPSILON * t2 * t2 > 1.0)) continue;
                        for (j = i; j <= nn; ++j) {
                            A.div(j, nn, t2);
                        }
                    }
                    continue;
                }
                if (!(q < 0.0)) continue;
                m = na;
                if (Math.abs(A.get(nn, na)) > Math.abs(A.get(na, nn))) {
                    A.set(na, na, q / A.get(nn, na));
                    A.set(na, nn, -(A.get(nn, nn) - p) / A.get(nn, na));
                } else {
                    temp = JMatrix.cdiv(0.0, -A.get(na, nn), A.get(na, na) - p, q);
                    A.set(na, na, temp.re);
                    A.set(na, nn, temp.im);
                }
                A.set(nn, na, 0.0);
                A.set(nn, nn, 1.0);
                for (i = nn - 2; i >= 0; --i) {
                    w = A.get(i, i) - p;
                    double sa = 0.0;
                    double ra = 0.0;
                    for (j = m; j <= nn; ++j) {
                        ra += A.get(i, j) * A.get(j, na);
                        sa += A.get(i, j) * A.get(j, nn);
                    }
                    if (e[i] < 0.0) {
                        z = w;
                        r = ra;
                        s = sa;
                    } else {
                        m = i;
                        if (e[i] == 0.0) {
                            temp = JMatrix.cdiv(-ra, -sa, w, q);
                            A.set(i, na, temp.re);
                            A.set(i, nn, temp.im);
                        } else {
                            x = A.get(i, i + 1);
                            y = A.get(i + 1, i);
                            double vr = MathEx.sqr(d[i] - p) + MathEx.sqr(e[i]) - q * q;
                            double vi = 2.0 * q * (d[i] - p);
                            if (vr == 0.0 && vi == 0.0) {
                                vr = MathEx.EPSILON * anorm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                            }
                            temp = JMatrix.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                            A.set(i, na, temp.re);
                            A.set(i, nn, temp.im);
                            if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                                A.set(i + 1, na, (-ra - w * A.get(i, na) + q * A.get(i, nn)) / x);
                                A.set(i + 1, nn, (-sa - w * A.get(i, nn) - q * A.get(i, na)) / x);
                            } else {
                                temp = JMatrix.cdiv(-r - y * A.get(i, na), -s - y * A.get(i, nn), z, q);
                                A.set(i + 1, na, temp.re);
                                A.set(i + 1, nn, temp.im);
                            }
                        }
                    }
                    t2 = Math.max(Math.abs(A.get(i, na)), Math.abs(A.get(i, nn)));
                    if (!(MathEx.EPSILON * t2 * t2 > 1.0)) continue;
                    for (j = i; j <= nn; ++j) {
                        A.div(j, na, t2);
                        A.div(j, nn, t2);
                    }
                }
            }
            for (j = n - 1; j >= 0; --j) {
                for (i = 0; i < n; ++i) {
                    z = 0.0;
                    for (k = 0; k <= j; ++k) {
                        z += V.get(i, k) * A.get(k, j);
                    }
                    V.set(i, j, z);
                }
            }
        }
    }

    private static Complex cdiv(double xr, double xi, double yr, double yi) {
        double cdivi;
        double cdivr;
        if (Math.abs(yr) > Math.abs(yi)) {
            double r = yi / yr;
            double d = yr + r * yi;
            cdivr = (xr + r * xi) / d;
            cdivi = (xi - r * xr) / d;
        } else {
            double r = yr / yi;
            double d = yi + r * yr;
            cdivr = (r * xr + xi) / d;
            cdivi = (r * xi - xr) / d;
        }
        return new Complex(cdivr, cdivi);
    }

    protected static void sort(double[] d, double[] e) {
        int i = 0;
        int n = d.length;
        for (int j = 1; j < n; ++j) {
            double real = d[j];
            double img = e[j];
            for (i = j - 1; i >= 0 && !(d[i] >= d[j]); --i) {
                d[i + 1] = d[i];
                e[i + 1] = e[i];
            }
            d[i + 1] = real;
            e[i + 1] = img;
        }
    }

    protected static void sort(double[] d, double[] e, DenseMatrix V) {
        int i = 0;
        int n = d.length;
        double[] temp = new double[n];
        for (int j = 1; j < n; ++j) {
            int k;
            double real = d[j];
            double img = e[j];
            for (k = 0; k < n; ++k) {
                temp[k] = V.get(k, j);
            }
            for (i = j - 1; i >= 0 && !(d[i] >= d[j]); --i) {
                d[i + 1] = d[i];
                e[i + 1] = e[i];
                for (k = 0; k < n; ++k) {
                    V.set(k, i + 1, V.get(k, i));
                }
            }
            d[i + 1] = real;
            e[i + 1] = img;
            for (k = 0; k < n; ++k) {
                V.set(k, i + 1, temp[k]);
            }
        }
    }
}

