/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.csv.CSVFormat;
import smile.data.DataFrame;
import smile.io.Arff;
import smile.io.Arrow;
import smile.io.CSV;

public interface Write {
    public static void csv(DataFrame df, Path path) throws IOException {
        Write.csv(df, path, CSVFormat.DEFAULT);
    }

    public static void csv(DataFrame df, Path path, CSVFormat format) throws IOException {
        CSV csv = new CSV(format);
        csv.write(df, path);
    }

    public static void arrow(DataFrame df, Path path) throws IOException {
        Arrow arrow = new Arrow();
        arrow.write(df, path);
    }

    public static void arff(DataFrame df, Path path, String relation) throws IOException {
        Arff.write(df, path, relation);
    }
}

