/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.BinarySparseDataset;
import smile.math.MathEx;
import smile.math.matrix.SparseMatrix;

class BinarySparseDatasetImpl
implements BinarySparseDataset {
    private static final Logger logger = LoggerFactory.getLogger(BinarySparseDatasetImpl.class);
    private int[][] data;
    private int n;
    private int ncols;
    private int[] colSize;

    public BinarySparseDatasetImpl(Collection<int[]> data) {
        this.data = (int[][])data.toArray((T[])new int[data.size()][]);
        this.ncols = MathEx.max((int[][])this.data) + 1;
        this.colSize = new int[this.ncols];
        for (int[] x : this.data) {
            Arrays.sort(x);
            int prev = -1;
            for (int xi : x) {
                if (xi < 0) {
                    throw new IllegalArgumentException(String.format("Negative index of nonzero element: %d", xi));
                }
                if (xi == prev) {
                    logger.warn(String.format("Ignore duplicated indices: %d in [%s]", xi, Arrays.toString(x)));
                    continue;
                }
                int n = xi;
                this.colSize[n] = this.colSize[n] + 1;
                ++this.n;
                prev = xi;
            }
        }
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public int length() {
        return this.n;
    }

    @Override
    public int ncols() {
        return this.ncols;
    }

    @Override
    public int[] get(int i) {
        return this.data[i];
    }

    @Override
    public Stream<int[]> stream() {
        return Arrays.stream(this.data);
    }

    @Override
    public SparseMatrix toMatrix() {
        int[] pos = new int[this.ncols];
        int[] colIndex = new int[this.ncols + 1];
        for (int i = 0; i < this.ncols; ++i) {
            colIndex[i + 1] = colIndex[i] + this.colSize[i];
        }
        int nrows = this.data.length;
        int[] rowIndex = new int[this.n];
        double[] x = new double[this.n];
        for (int i = 0; i < nrows; ++i) {
            for (int j : this.data[i]) {
                int k = colIndex[j] + pos[j];
                rowIndex[k] = i;
                x[k] = 1.0;
                int n = j;
                pos[n] = pos[n] + 1;
            }
        }
        return new SparseMatrix(nrows, this.ncols, x, rowIndex, colIndex);
    }
}

