/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import smile.data.Tuple;
import smile.data.formula.AbstractTerm;
import smile.data.formula.OneHotEncoder;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructType;

class OneHotEncoderInteraction
extends AbstractTerm {
    List<OneHotEncoder> encoders;

    public OneHotEncoderInteraction(List<OneHotEncoder> encoders) {
        this.encoders = encoders;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public Set<String> variables() {
        HashSet<String> set = new HashSet<String>();
        for (OneHotEncoder encoder : this.encoders) {
            set.addAll(encoder.variables());
        }
        return set;
    }

    @Override
    public Object apply(Tuple o) {
        return this.applyAsByte(o);
    }

    @Override
    public byte applyAsByte(Tuple o) {
        for (OneHotEncoder encoder : this.encoders) {
            if (encoder.applyAsByte(o) != 0) continue;
            return 0;
        }
        return 1;
    }

    @Override
    public String name() {
        return this.encoders.stream().map(encoder -> encoder.name()).collect(Collectors.joining("-"));
    }

    @Override
    public DataType type() {
        return DataTypes.ByteType;
    }

    @Override
    public void bind(StructType schema) {
    }
}

