/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.type.DataType;
import smile.data.type.ObjectType;
import smile.data.type.StructType;
import smile.data.vector.BaseVector;
import smile.data.vector.BooleanVector;
import smile.data.vector.ByteVector;
import smile.data.vector.CharVector;
import smile.data.vector.DoubleVector;
import smile.data.vector.FloatVector;
import smile.data.vector.IntVector;
import smile.data.vector.LongVector;
import smile.data.vector.ShortVector;
import smile.data.vector.StringVector;
import smile.data.vector.Vector;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;

public class IndexDataFrame
implements DataFrame {
    private static final Logger logger = LoggerFactory.getLogger(IndexDataFrame.class);
    private DataFrame df;
    private int[] index;

    public IndexDataFrame(DataFrame df, int[] index) {
        this.df = df;
        this.index = index;
    }

    @Override
    public StructType schema() {
        return this.df.schema();
    }

    public String toString() {
        return this.toString(10, true);
    }

    @Override
    public Iterator<BaseVector> iterator() {
        return this.df.iterator();
    }

    @Override
    public int columnIndex(String name) {
        return this.df.columnIndex(name);
    }

    @Override
    public int size() {
        return this.index.length;
    }

    @Override
    public int ncols() {
        return this.df.ncols();
    }

    @Override
    public Object get(int i, int j) {
        return this.df.get(this.index[i], j);
    }

    @Override
    public Stream<Tuple> stream() {
        return Arrays.stream(this.index).mapToObj(i -> (Tuple)this.df.get(i));
    }

    @Override
    public BaseVector column(int i) {
        return this.df.column(i).get(this.index);
    }

    @Override
    public <T> Vector<T> vector(int i) {
        return this.df.vector(i);
    }

    @Override
    public BooleanVector booleanVector(int i) {
        return this.df.booleanVector(i);
    }

    @Override
    public CharVector charVector(int i) {
        return this.df.charVector(i);
    }

    @Override
    public ByteVector byteVector(int i) {
        return this.df.byteVector(i);
    }

    @Override
    public ShortVector shortVector(int i) {
        return this.df.shortVector(i);
    }

    @Override
    public IntVector intVector(int i) {
        return this.df.intVector(i);
    }

    @Override
    public LongVector longVector(int i) {
        return this.df.longVector(i);
    }

    @Override
    public FloatVector floatVector(int i) {
        return this.df.floatVector(i);
    }

    @Override
    public DoubleVector doubleVector(int i) {
        return this.df.doubleVector(i);
    }

    @Override
    public StringVector stringVector(int i) {
        return this.df.stringVector(i);
    }

    @Override
    public DataFrame select(int ... cols) {
        return new IndexDataFrame(this.df.select(cols), this.index);
    }

    @Override
    public DataFrame drop(int ... cols) {
        return new IndexDataFrame(this.df.drop(cols), this.index);
    }

    private DataFrame rebase() {
        return DataFrame.of(this.stream().collect(Collectors.toList()));
    }

    @Override
    public DataFrame merge(DataFrame ... dataframes) {
        for (DataFrame df : dataframes) {
            if (df.size() == this.size()) continue;
            throw new IllegalArgumentException("Merge data frames with different size: " + this.size() + " vs " + df.size());
        }
        return this.rebase().merge(dataframes);
    }

    @Override
    public DataFrame merge(BaseVector ... vectors) {
        for (BaseVector vector : vectors) {
            if (vector.size() == this.size()) continue;
            throw new IllegalArgumentException("Merge data frames with different size: " + this.size() + " vs " + vector.size());
        }
        return this.rebase().merge(vectors);
    }

    @Override
    public DataFrame union(DataFrame ... dataframes) {
        for (DataFrame df : dataframes) {
            if (this.schema().equals(df.schema())) continue;
            throw new IllegalArgumentException("Union data frames with different schema: " + this.schema() + " vs " + df.schema());
        }
        return this.rebase().union(dataframes);
    }

    @Override
    public Tuple get(int i) {
        return (Tuple)this.df.get(this.index[i]);
    }

    @Override
    public double[][] toArray() {
        int nrows = this.nrows();
        int ncols = this.ncols();
        DataType[] types = this.types();
        double[][] m = new double[nrows][ncols];
        block12: for (int j = 0; j < ncols; ++j) {
            DataType type = types[j];
            switch (type.id()) {
                case Double: {
                    BaseVector<Double, Double, DoubleStream> v = this.doubleVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m[i][j] = v.getDouble(this.index[i]);
                    }
                    continue block12;
                }
                case Integer: {
                    BaseVector<Double, Double, DoubleStream> v = this.intVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m[i][j] = v.getInt(this.index[i]);
                    }
                    continue block12;
                }
                case Float: {
                    BaseVector<Double, Double, DoubleStream> v = this.floatVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m[i][j] = v.getFloat(this.index[i]);
                    }
                    continue block12;
                }
                case Long: {
                    BaseVector<Double, Double, DoubleStream> v = this.longVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m[i][j] = v.getLong(this.index[i]);
                    }
                    continue block12;
                }
                case Boolean: {
                    BaseVector<Double, Double, DoubleStream> v = this.booleanVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m[i][j] = v.getDouble(this.index[i]);
                    }
                    continue block12;
                }
                case Byte: {
                    BaseVector<Double, Double, DoubleStream> v = this.byteVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m[i][j] = v.getByte(this.index[i]);
                    }
                    continue block12;
                }
                case Short: {
                    BaseVector<Double, Double, DoubleStream> v = this.shortVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m[i][j] = v.getShort(this.index[i]);
                    }
                    continue block12;
                }
                case Char: {
                    BaseVector<Double, Double, DoubleStream> v = this.charVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m[i][j] = v.getChar(this.index[i]);
                    }
                    continue block12;
                }
                case String: {
                    BaseVector<Double, Double, DoubleStream> v = this.stringVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        String s = (String)((Object)v.get(this.index[i]));
                        m[i][j] = s == null ? Double.NaN : Double.valueOf(s);
                    }
                    continue block12;
                }
                case Object: {
                    int i;
                    Class clazz = ((ObjectType)type).getObjectClass();
                    if (clazz == Boolean.class) {
                        Vector v = this.vector(j);
                        for (i = 0; i < nrows; ++i) {
                            Boolean b = (Boolean)v.get(this.index[i]);
                            m[i][j] = b != null ? (b != false ? 1.0 : 0.0) : Double.NaN;
                        }
                        continue block12;
                    }
                    if (Number.class.isAssignableFrom(clazz)) {
                        Vector v = this.vector(j);
                        for (i = 0; i < nrows; ++i) {
                            m[i][j] = v.getDouble(this.index[i]);
                        }
                        continue block12;
                    }
                    throw new UnsupportedOperationException(String.format("DataFrame.toMatrix() doesn't support type %s", type));
                }
                default: {
                    throw new UnsupportedOperationException(String.format("DataFrame.toMatrix() doesn't support type %s", type));
                }
            }
        }
        return m;
    }

    @Override
    public DenseMatrix toMatrix() {
        int nrows = this.nrows();
        int ncols = this.ncols();
        DataType[] types = this.types();
        DenseMatrix m = Matrix.of((int)nrows, (int)ncols, (double)0.0);
        block12: for (int j = 0; j < ncols; ++j) {
            DataType type = types[j];
            switch (type.id()) {
                case Double: {
                    BaseVector<Double, Double, DoubleStream> v = this.doubleVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m.set(i, j, v.getDouble(this.index[i]));
                    }
                    continue block12;
                }
                case Integer: {
                    BaseVector<Double, Double, DoubleStream> v = this.intVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m.set(i, j, (double)v.getInt(this.index[i]));
                    }
                    continue block12;
                }
                case Float: {
                    BaseVector<Double, Double, DoubleStream> v = this.floatVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m.set(i, j, (double)v.getFloat(this.index[i]));
                    }
                    continue block12;
                }
                case Long: {
                    BaseVector<Double, Double, DoubleStream> v = this.longVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m.set(i, j, (double)v.getLong(this.index[i]));
                    }
                    continue block12;
                }
                case Boolean: {
                    BaseVector<Double, Double, DoubleStream> v = this.booleanVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m.set(i, j, v.getDouble(this.index[i]));
                    }
                    continue block12;
                }
                case Byte: {
                    BaseVector<Double, Double, DoubleStream> v = this.byteVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m.set(i, j, (double)v.getByte(this.index[i]));
                    }
                    continue block12;
                }
                case Short: {
                    BaseVector<Double, Double, DoubleStream> v = this.shortVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m.set(i, j, (double)v.getShort(this.index[i]));
                    }
                    continue block12;
                }
                case Char: {
                    BaseVector<Double, Double, DoubleStream> v = this.charVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m.set(i, j, (double)v.getChar(this.index[i]));
                    }
                    continue block12;
                }
                case String: {
                    BaseVector<Double, Double, DoubleStream> v = this.stringVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        String s = (String)((Object)v.get(this.index[i]));
                        m.set(i, j, s == null ? Double.NaN : Double.valueOf(s));
                    }
                    continue block12;
                }
                case Object: {
                    int i;
                    Class clazz = ((ObjectType)type).getObjectClass();
                    if (clazz == Boolean.class) {
                        Vector v = this.vector(j);
                        for (i = 0; i < nrows; ++i) {
                            Boolean b = (Boolean)v.get(this.index[i]);
                            if (b != null) {
                                m.set(i, j, b != false ? 1.0 : 0.0);
                                continue;
                            }
                            m.set(i, j, Double.NaN);
                        }
                        continue block12;
                    }
                    if (Number.class.isAssignableFrom(clazz)) {
                        Vector v = this.vector(j);
                        for (i = 0; i < nrows; ++i) {
                            m.set(i, j, v.getDouble(this.index[i]));
                        }
                        continue block12;
                    }
                    throw new UnsupportedOperationException(String.format("DataFrame.toMatrix() doesn't support type %s", type));
                }
                default: {
                    throw new UnsupportedOperationException(String.format("DataFrame.toMatrix() doesn't support type %s", type));
                }
            }
        }
        return m;
    }
}

