/*
 * Decompiled with CFR 0.152.
 */
package smile.validation.metric;

import smile.math.MathEx;
import smile.validation.metric.ClusteringMetric;
import smile.validation.metric.ContingencyTable;

public class AdjustedRandIndex
implements ClusteringMetric {
    private static final long serialVersionUID = 2L;
    public static final AdjustedRandIndex instance = new AdjustedRandIndex();

    @Override
    public double score(int[] truth, int[] cluster) {
        return AdjustedRandIndex.of(truth, cluster);
    }

    public static double of(int[] truth, int[] cluster) {
        ContingencyTable contingency = new ContingencyTable(truth, cluster);
        int n = contingency.n;
        int n1 = contingency.n1;
        int n2 = contingency.n2;
        int[] a = contingency.a;
        int[] b = contingency.b;
        int[][] count = contingency.table;
        double rand1 = 0.0;
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (count[i][j] < 2) continue;
                rand1 += MathEx.choose((int)count[i][j], (int)2);
            }
        }
        double rand2a = 0.0;
        for (int i = 0; i < n1; ++i) {
            if (a[i] < 2) continue;
            rand2a += MathEx.choose((int)a[i], (int)2);
        }
        double rand2b = 0.0;
        for (int j = 0; j < n2; ++j) {
            if (b[j] < 2) continue;
            rand2b += MathEx.choose((int)b[j], (int)2);
        }
        double rand3 = rand2a * rand2b;
        double rand_N = rand1 - (rand3 /= MathEx.choose((int)n, (int)2));
        double rand4 = (rand2a + rand2b) / 2.0;
        double randD = rand4 - rand3;
        return rand_N / randD;
    }

    public String toString() {
        return "AdjustedRandIndex";
    }
}

