/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import java.util.function.Function;
import smile.linalg.UPLO;
import smile.math.MathEx;
import smile.math.kernel.MercerKernel;
import smile.tensor.ARPACK;
import smile.tensor.DenseMatrix;
import smile.tensor.EVD;
import smile.tensor.Matrix;
import smile.tensor.ScalarType;
import smile.tensor.Vector;

public class KPCA<T>
implements Function<T, double[]>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final T[] data;
    private final MercerKernel<T> kernel;
    private final double[] mean;
    private final double mu;
    private final double[] latent;
    private final DenseMatrix projection;
    private final double[][] coordinates;

    public KPCA(T[] data, MercerKernel<T> kernel, double[] mean, double mu, double[][] coordinates, double[] latent, DenseMatrix projection) {
        this.data = data;
        this.kernel = kernel;
        this.mean = mean;
        this.mu = mu;
        this.coordinates = coordinates;
        this.latent = latent;
        this.projection = projection;
    }

    public static <T> KPCA<T> fit(T[] data, MercerKernel<T> kernel, Options options) {
        int d = options.d;
        if (d > data.length) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + d);
        }
        int n = data.length;
        DenseMatrix K = DenseMatrix.zeros((ScalarType)ScalarType.Float64, (int)n, (int)n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                double x = kernel.k(data[i], data[j]);
                K.set(i, j, x);
                K.set(j, i, x);
            }
        }
        double[] mean = K.rowMeans().toArray(new double[0]);
        double mu = MathEx.mean((double[])mean);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                double x = K.get(i, j) - mean[i] - mean[j] + mu;
                K.set(i, j, x);
                K.set(j, i, x);
            }
        }
        K.withUplo(UPLO.LOWER);
        EVD eigen = ARPACK.syev((Matrix)K, (ARPACK.SymmOption)ARPACK.SymmOption.LA, (int)d);
        double[] eigvalues = eigen.wr().toArray(new double[0]);
        DenseMatrix eigvectors = eigen.Vr();
        int p = (int)Arrays.stream(eigvalues).limit(d).filter(e -> e / (double)n > options.threshold).count();
        double[] latent = new double[p];
        DenseMatrix projection = DenseMatrix.zeros((ScalarType)ScalarType.Float64, (int)p, (int)n);
        for (int j = 0; j < p; ++j) {
            latent[j] = eigvalues[j];
            double s = Math.sqrt(latent[j]);
            for (int i = 0; i < n; ++i) {
                projection.set(j, i, eigvectors.get(i, j) / s);
            }
        }
        DenseMatrix coord = projection.mm(K);
        double[][] coordinates = new double[n][p];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < p; ++j) {
                coordinates[i][j] = coord.get(j, i);
            }
        }
        return new KPCA<T>(data, kernel, mean, mu, coordinates, latent, projection);
    }

    public double[] variances() {
        return this.latent;
    }

    public DenseMatrix projection() {
        return this.projection;
    }

    public double[][] coordinates() {
        return this.coordinates;
    }

    @Override
    public double[] apply(T x) {
        int n = this.data.length;
        Vector y = this.projection.vector(n);
        for (int i = 0; i < n; ++i) {
            y.set(i, this.kernel.k(x, this.data[i]));
        }
        double my = y.mean();
        for (int i = 0; i < n; ++i) {
            y.sub(i, my + this.mean[i] - this.mu);
        }
        return this.projection.mv(y).toArray(new double[0]);
    }

    @Override
    public double[][] apply(T[] x) {
        int m = x.length;
        double[][] y = new double[m][];
        for (int i = 0; i < m; ++i) {
            y[i] = this.apply(x[i]);
        }
        return y;
    }

    public record Options(int d, double threshold) {
        public Options {
            if (d < 2) {
                throw new IllegalArgumentException("Invalid dimension of feature space: " + d);
            }
            if (threshold < 0.0) {
                throw new IllegalArgumentException("Invalid threshold = " + threshold);
            }
        }

        public Options(int d) {
            this(d, 1.0E-4);
        }

        public Properties toProperties() {
            Properties props = new Properties();
            props.setProperty("smile.kpca.d", Integer.toString(this.d));
            props.setProperty("smile.kpca.threshold", Double.toString(this.threshold));
            return props;
        }

        public static Options of(Properties props) {
            int d = Integer.parseInt(props.getProperty("smile.kpca.d", "2"));
            double threshold = Double.parseDouble(props.getProperty("smile.kpca.threshold", "0.0001"));
            return new Options(d, threshold);
        }
    }
}

