/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.transform;

import java.io.Serializable;
import java.util.HashMap;
import smile.data.DataFrame;
import smile.data.transform.InvertibleColumnTransform;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.math.MathEx;
import smile.util.function.Function;

public interface Scaler {
    public static InvertibleColumnTransform fit(DataFrame data, String ... columns) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Empty data frame");
        }
        StructType schema = data.schema();
        if (columns.length == 0) {
            columns = (String[])schema.fields().stream().filter(StructField::isNumeric).map(StructField::name).toArray(String[]::new);
        }
        HashMap<String, 1> transforms = new HashMap<String, 1>();
        HashMap<String, Function & Serializable> inverses = new HashMap<String, Function & Serializable>();
        for (String column : columns) {
            final StructField field = schema.field(column);
            if (!field.isNumeric()) {
                throw new IllegalArgumentException(String.format("%s is not numeric", field.name()));
            }
            double[] vector = data.column(column).toDoubleArray();
            final double lo = MathEx.min((double[])vector);
            double hi = MathEx.max((double[])vector);
            double span = hi - lo;
            final double scale = MathEx.isZero((double)span) ? 1.0 : hi - lo;
            Function transform = new Function(){

                public double f(double x) {
                    double y = (x - lo) / scale;
                    if (y < 0.0) {
                        y = 0.0;
                    }
                    if (y > 1.0) {
                        y = 1.0;
                    }
                    return y;
                }

                public String toString() {
                    return lo >= 0.0 ? String.format("(%s - %.4f) / %.4f", field.name(), lo, scale) : String.format("(%s + %.4f) / %.4f", field.name(), -lo, scale);
                }
            };
            Function & Serializable inverse = (Function & Serializable)x -> x * scale + lo;
            transforms.put(field.name(), transform);
            inverses.put(field.name(), inverse);
        }
        return new InvertibleColumnTransform("Scaler", transforms, inverses);
    }
}

