/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.extraction;

import smile.data.DataFrame;
import smile.feature.extraction.Projection;
import smile.linalg.UPLO;
import smile.math.MathEx;
import smile.tensor.Cholesky;
import smile.tensor.DenseMatrix;
import smile.tensor.EVD;
import smile.tensor.ScalarType;
import smile.tensor.Vector;

public class ProbabilisticPCA
extends Projection {
    private static final long serialVersionUID = 2L;
    private final Vector mu;
    private final Vector pmu;
    private final double noise;
    private final DenseMatrix loading;

    public ProbabilisticPCA(double noise, double[] mu, DenseMatrix loading, DenseMatrix projection, String ... columns) {
        super(projection, "PPCA", columns);
        this.noise = noise;
        this.mu = Vector.column((double[])mu);
        this.pmu = projection.mv(this.mu);
        this.loading = loading;
    }

    public DenseMatrix loadings() {
        return this.loading;
    }

    public Vector center() {
        return this.mu;
    }

    public double variance() {
        return this.noise;
    }

    @Override
    protected double[] postprocess(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            int n = i;
            x[n] = x[n] - this.pmu.get(i);
        }
        return x;
    }

    public static ProbabilisticPCA fit(DataFrame data, int k, String ... columns) {
        double[][] x = data.toArray(columns);
        return ProbabilisticPCA.fit(x, k, columns);
    }

    public static ProbabilisticPCA fit(double[][] data, int k, String ... columns) {
        int m = data.length;
        int n = data[0].length;
        double[] mu = MathEx.colMeans((double[][])data);
        DenseMatrix cov = DenseMatrix.zeros((ScalarType)ScalarType.Float64, (int)n, (int)n);
        for (double[] datum : data) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j <= i; ++j) {
                    cov.add(i, j, (datum[i] - mu[i]) * (datum[j] - mu[j]));
                }
            }
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                cov.div(i, j, (double)m);
                cov.set(j, i, cov.get(i, j));
            }
        }
        cov.withUplo(UPLO.LOWER);
        EVD eigen = cov.eigen().sort();
        Vector eigvalues = eigen.wr();
        DenseMatrix eigvectors = eigen.Vr();
        double noise = 0.0;
        for (int i = k; i < n; ++i) {
            noise += eigvalues.get(i);
        }
        noise /= (double)(n - k);
        DenseMatrix loading = DenseMatrix.zeros((ScalarType)ScalarType.Float64, (int)n, (int)k);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < k; ++j) {
                loading.set(i, j, eigvectors.get(i, j) * Math.sqrt(eigvalues.get(j) - noise));
            }
        }
        DenseMatrix M2 = loading.ata();
        for (int i = 0; i < n; ++i) {
            M2.add(i, i, noise);
        }
        Cholesky chol = M2.cholesky();
        DenseMatrix Mi = chol.inverse();
        DenseMatrix projection = Mi.mt(loading);
        return new ProbabilisticPCA(noise, mu, loading, projection, columns);
    }
}

