/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.io.Serializable;

public class Partitioning
implements Serializable {
    private static final long serialVersionUID = 1L;
    final int k;
    final int[] group;
    final int[] size;

    public Partitioning(int k, int[] group) {
        this.k = k;
        this.group = group;
        this.size = new int[k + 1];
        for (int yi : group) {
            if (yi == Integer.MAX_VALUE) {
                int n = k;
                this.size[n] = this.size[n] + 1;
                continue;
            }
            int n = yi;
            this.size[n] = this.size[n] + 1;
        }
    }

    public int k() {
        return this.k;
    }

    public int[] group() {
        return this.group;
    }

    public int group(int i) {
        return this.group[i];
    }

    public int[] size() {
        return this.size;
    }

    public int size(int i) {
        return this.size[i];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String name = this.getClass().getSimpleName();
        sb.append(String.format("%-11s %15s%n", name, "Size (%)"));
        for (int i = 0; i < this.k; ++i) {
            double percent = 100.0 * (double)this.size[i] / (double)this.group.length;
            sb.append(String.format("Cluster %-3d %7d (%4.1f%%)%n", i + 1, this.size[i], percent));
        }
        if (this.size[this.k] != 0) {
            double r = 100.0 * (double)this.size[this.k] / (double)this.group.length;
            sb.append(String.format("%-11s %7d (%4.1f%%)%n", "Outliers", this.size[this.k], r));
        }
        sb.append(String.format("%-11s %7d (100.%%)%n", "Total", this.group.length));
        return sb.toString();
    }
}

