/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import smile.util.AlgoStatus;
import smile.util.IterativeAlgorithmController;

public interface Clustering {
    public static final int OUTLIER = Integer.MAX_VALUE;

    public static <T extends Comparable<? super T>> T run(int runs, Supplier<T> clustering) {
        if (runs <= 0) {
            throw new IllegalArgumentException("Invalid number of runs: " + runs);
        }
        return (T)IntStream.range(0, runs).mapToObj(run -> (Comparable)clustering.get()).min(Comparator.naturalOrder()).orElseThrow(NoSuchElementException::new);
    }

    public record Options(int k, int maxIter, double tol, IterativeAlgorithmController<AlgoStatus> controller) {
        public Options {
            if (k < 2) {
                throw new IllegalArgumentException("Invalid number of clusters: " + k);
            }
            if (maxIter <= 0) {
                throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
            }
            if (tol < 0.0) {
                throw new IllegalArgumentException("Invalid tolerance: " + tol);
            }
        }

        public Options(int k, int maxIter) {
            this(k, maxIter, 1.0E-4, null);
        }

        public Properties toProperties() {
            Properties props = new Properties();
            props.setProperty("smile.clustering.k", Integer.toString(this.k));
            props.setProperty("smile.clustering.iterations", Integer.toString(this.maxIter));
            props.setProperty("smile.clustering.tolerance", Double.toString(this.tol));
            return props;
        }

        public static Options of(Properties props) {
            int k = Integer.parseInt(props.getProperty("smile.clustering.k", "2"));
            int maxIter = Integer.parseInt(props.getProperty("smile.clustering.iterations", "100"));
            double tol = Double.parseDouble(props.getProperty("smile.clustering.tolerance", "1E-4"));
            return new Options(k, maxIter, tol, null);
        }
    }
}

