/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import smile.base.svm.KernelMachine;
import smile.base.svm.LinearKernelMachine;
import smile.classification.AbstractClassifier;
import smile.util.IntSet;
import smile.util.SparseArray;

public class SparseLinearSVM
extends AbstractClassifier<SparseArray> {
    private final LinearKernelMachine model;

    public SparseLinearSVM(int p, KernelMachine<SparseArray> svm) {
        super(new IntSet(new int[]{-1, 1}));
        this.model = LinearKernelMachine.sparse(p, svm);
    }

    public double[] weights() {
        return this.model.weights();
    }

    public double intercept() {
        return this.model.intercept();
    }

    @Override
    public int predict(SparseArray x) {
        return this.model.f(x) > 0.0 ? 1 : -1;
    }

    @Override
    public double score(SparseArray x) {
        return this.model.f(x);
    }
}

