/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import smile.sort.QuickSort;

public class IsotonicRegressionScaling
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final double[] buckets;
    private final double[] prob;

    public IsotonicRegressionScaling(double[] buckets, double[] prob) {
        this.buckets = (double[])buckets.clone();
        this.prob = prob;
        int n = buckets.length;
        this.buckets[n - 1] = Double.POSITIVE_INFINITY;
    }

    public static IsotonicRegressionScaling fit(double[] scores, int[] y) {
        double[] sortedScores = Arrays.copyOf(scores, scores.length);
        int[] sortedY = Arrays.copyOf(y, y.length);
        QuickSort.sort((double[])sortedScores, (int[])sortedY, (int)sortedScores.length);
        LinkedList<StepwiseConstant> steps = new LinkedList<StepwiseConstant>();
        for (int i = 0; i < sortedScores.length; ++i) {
            steps.add(new StepwiseConstant(sortedScores[i], sortedScores[i], sortedY[i] > 0 ? 1.0 : 0.0, 1));
        }
        boolean isotonic = false;
        while (!isotonic) {
            isotonic = true;
            Iterator iter = steps.iterator();
            StepwiseConstant prev = (StepwiseConstant)iter.next();
            while (iter.hasNext()) {
                StepwiseConstant g0 = prev;
                StepwiseConstant g1 = (StepwiseConstant)iter.next();
                if (g0.val >= g1.val) {
                    g0.hi = g1.hi;
                    int weight = g0.weight + g1.weight;
                    g0.val = ((double)g0.weight * g0.val + (double)g1.weight * g1.val) / (double)weight;
                    g0.weight = weight;
                    iter.remove();
                    isotonic = false;
                    continue;
                }
                prev = g1;
            }
        }
        int n = steps.size();
        double[] buckets = new double[n];
        double[] prob = new double[n];
        Iterator iter = steps.iterator();
        int i = 0;
        while (iter.hasNext()) {
            StepwiseConstant step = (StepwiseConstant)iter.next();
            buckets[i] = step.hi;
            prob[i] = step.val;
            ++i;
        }
        return new IsotonicRegressionScaling(buckets, prob);
    }

    public double predict(double y) {
        int index = Arrays.binarySearch(this.buckets, y);
        if (index < 0) {
            index = -index - 1;
        }
        return this.prob[index];
    }

    public String toString() {
        return IntStream.range(0, this.buckets.length).mapToObj(i -> String.format("(%.2f, %.2f%%)", this.buckets[i], 100.0 * this.prob[i])).collect(Collectors.joining(", ", "IsotonicRegressionScaling[", "]"));
    }

    private static class StepwiseConstant {
        final double lo;
        double hi;
        double val;
        int weight;

        StepwiseConstant(double lo, double hi, double val, int weight) {
            this.lo = lo;
            this.hi = hi;
            this.val = val;
            this.weight = weight;
        }
    }
}

