/*
 * Decompiled with CFR 0.152.
 */
package smile.base.mlp;

import java.io.IOException;
import java.io.ObjectInputStream;
import smile.base.mlp.Layer;
import smile.tensor.Vector;

public class InputLayer
extends Layer {
    private static final long serialVersionUID = 2L;

    public InputLayer(int p) {
        this(p, 0.0);
    }

    public InputLayer(int p, double dropout) {
        super(p, dropout);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.output = ThreadLocal.withInitial(() -> this.weight.vector(this.n));
        if (this.dropout > 0.0) {
            this.mask = ThreadLocal.withInitial(() -> new byte[this.n]);
        }
    }

    public String toString() {
        if (this.dropout > 0.0) {
            return String.format("Input(%d, %.2f)", this.n, this.dropout);
        }
        return String.format("Input(%d)", this.n);
    }

    @Override
    public void propagate(Vector x) {
        Vector.copy((Vector)x, (int)0, (Vector)((Vector)this.output.get()), (int)0, (int)this.p);
    }

    @Override
    public void backpropagate(Vector lowerLayerGradient) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void transform(Vector x) {
    }

    @Override
    public void computeGradient(Vector x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void computeGradientUpdate(Vector x, double learningRate, double momentum, double decay) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(int m, double learningRate, double momentum, double decay, double rho, double epsilon) {
        throw new UnsupportedOperationException();
    }
}

