/*
 * Decompiled with CFR 0.152.
 */
package smile.base.mlp;

import java.io.Serializable;
import smile.math.MathEx;
import smile.tensor.Vector;

public interface ActivationFunction
extends Serializable {
    public String name();

    public void f(Vector var1);

    public void g(Vector var1, Vector var2);

    public static ActivationFunction linear() {
        return new ActivationFunction(){

            @Override
            public String name() {
                return "LINEAR";
            }

            @Override
            public void f(Vector x) {
            }

            @Override
            public void g(Vector g, Vector y) {
            }
        };
    }

    public static ActivationFunction rectifier() {
        return new ActivationFunction(){

            @Override
            public String name() {
                return "RECTIFIER";
            }

            @Override
            public void f(Vector x) {
                int n = x.size();
                for (int i = 0; i < n; ++i) {
                    x.set(i, Math.max(0.0, x.get(i)));
                }
            }

            @Override
            public void g(Vector g, Vector y) {
                int n = y.size();
                for (int i = 0; i < n; ++i) {
                    g.mul(i, y.get(i) > 0.0 ? 1.0 : 0.0);
                }
            }
        };
    }

    public static ActivationFunction leaky() {
        return ActivationFunction.leaky(0.01);
    }

    public static ActivationFunction leaky(final double a) {
        if (a < 0.0 || a >= 1.0) {
            throw new IllegalArgumentException("Invalid Leaky ReLU parameter: " + a);
        }
        return new ActivationFunction(){

            @Override
            public String name() {
                return String.format("LEAKEY_RECTIFIER(%f)", a);
            }

            @Override
            public void f(Vector x) {
                int n = x.size();
                for (int i = 0; i < n; ++i) {
                    double xi = x.get(i);
                    x.set(i, Math.max(a * xi, xi));
                }
            }

            @Override
            public void g(Vector g, Vector y) {
                int n = y.size();
                for (int i = 0; i < n; ++i) {
                    g.mul(i, y.get(i) > 0.0 ? 1.0 : a);
                }
            }
        };
    }

    public static ActivationFunction sigmoid() {
        return new ActivationFunction(){

            @Override
            public String name() {
                return "SIGMOID";
            }

            @Override
            public void f(Vector x) {
                int n = x.size();
                for (int i = 0; i < n; ++i) {
                    x.set(i, MathEx.sigmoid((double)x.get(i)));
                }
            }

            @Override
            public void g(Vector g, Vector y) {
                int n = y.size();
                for (int i = 0; i < n; ++i) {
                    double yi = y.get(i);
                    g.mul(i, yi * (1.0 - yi));
                }
            }
        };
    }

    public static ActivationFunction tanh() {
        return new ActivationFunction(){

            @Override
            public String name() {
                return "TANH";
            }

            @Override
            public void f(Vector x) {
                int n = x.size();
                for (int i = 0; i < n; ++i) {
                    x.set(i, Math.tanh(x.get(i)));
                }
            }

            @Override
            public void g(Vector g, Vector y) {
                int n = y.size();
                for (int i = 0; i < n; ++i) {
                    double ym1 = 1.0 - y.get(i);
                    g.mul(i, ym1 * ym1);
                }
            }
        };
    }
}

