/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import java.io.Serializable;
import java.util.List;
import smile.math.MathEx;
import smile.validation.ClassificationMetrics;
import smile.validation.ClassificationValidation;

public class ClassificationValidations<M>
implements Serializable {
    private static final long serialVersionUID = 2L;
    public final List<ClassificationValidation<M>> rounds;
    public final ClassificationMetrics avg;
    public final ClassificationMetrics sd;

    public ClassificationValidations(List<ClassificationValidation<M>> rounds) {
        this.rounds = rounds;
        int k = rounds.size();
        double[] fitTime = new double[k];
        double[] scoreTime = new double[k];
        int[] size = new int[k];
        int[] error = new int[k];
        double[] accuracy = new double[k];
        double[] sensitivity = new double[k];
        double[] specificity = new double[k];
        double[] precision = new double[k];
        double[] f1 = new double[k];
        double[] mcc = new double[k];
        double[] auc = new double[k];
        double[] logloss = new double[k];
        double[] crossentropy = new double[k];
        for (int i = 0; i < k; ++i) {
            ClassificationMetrics metrics = rounds.get((int)i).metrics;
            fitTime[i] = metrics.fitTime;
            scoreTime[i] = metrics.scoreTime;
            size[i] = metrics.size;
            error[i] = metrics.error;
            accuracy[i] = metrics.accuracy;
            sensitivity[i] = metrics.sensitivity;
            specificity[i] = metrics.specificity;
            precision[i] = metrics.precision;
            f1[i] = metrics.f1;
            mcc[i] = metrics.mcc;
            auc[i] = metrics.auc;
            logloss[i] = metrics.logloss;
            crossentropy[i] = metrics.crossentropy;
        }
        this.avg = new ClassificationMetrics(MathEx.mean((double[])fitTime), MathEx.mean((double[])scoreTime), (int)Math.round(MathEx.mean((int[])size)), (int)Math.round(MathEx.mean((int[])error)), MathEx.mean((double[])accuracy), MathEx.mean((double[])sensitivity), MathEx.mean((double[])specificity), MathEx.mean((double[])precision), MathEx.mean((double[])f1), MathEx.mean((double[])mcc), MathEx.mean((double[])auc), MathEx.mean((double[])logloss), MathEx.mean((double[])crossentropy));
        this.sd = new ClassificationMetrics(MathEx.sd((double[])fitTime), MathEx.sd((double[])scoreTime), (int)Math.round(MathEx.sd((int[])size)), (int)Math.round(MathEx.sd((int[])error)), MathEx.sd((double[])accuracy), MathEx.sd((double[])sensitivity), MathEx.sd((double[])specificity), MathEx.sd((double[])precision), MathEx.sd((double[])f1), MathEx.sd((double[])mcc), MathEx.sd((double[])auc), MathEx.sd((double[])logloss), MathEx.sd((double[])crossentropy));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{\n");
        sb.append(String.format("  fit time: %.3f ms \u00b1 %.3f,\n", this.avg.fitTime, this.sd.fitTime));
        sb.append(String.format("  score time: %.3f ms \u00b1 %.3f,\n", this.avg.scoreTime, this.sd.scoreTime));
        sb.append(String.format("  validation data size: %d \u00b1 %d,\n", this.avg.size, this.sd.size));
        sb.append(String.format("  error: %d \u00b1 %d,\n", this.avg.error, this.sd.error));
        sb.append(String.format("  accuracy: %.2f%% \u00b1 %.2f", 100.0 * this.avg.accuracy, 100.0 * this.sd.accuracy));
        if (!Double.isNaN(this.avg.sensitivity)) {
            sb.append(String.format(",\n  sensitivity: %.2f%% \u00b1 %.2f", 100.0 * this.avg.sensitivity, 100.0 * this.sd.sensitivity));
        }
        if (!Double.isNaN(this.avg.specificity)) {
            sb.append(String.format(",\n  specificity: %.2f%% \u00b1 %.2f", 100.0 * this.avg.specificity, 100.0 * this.sd.specificity));
        }
        if (!Double.isNaN(this.avg.precision)) {
            sb.append(String.format(",\n  precision: %.2f%% \u00b1 %.2f", 100.0 * this.avg.precision, 100.0 * this.sd.precision));
        }
        if (!Double.isNaN(this.avg.f1)) {
            sb.append(String.format(",\n  F1 score: %.2f%% \u00b1 %.2f", 100.0 * this.avg.f1, 100.0 * this.sd.f1));
        }
        if (!Double.isNaN(this.avg.mcc)) {
            sb.append(String.format(",\n  MCC: %.2f%% \u00b1 %.2f", 100.0 * this.avg.mcc, 100.0 * this.sd.mcc));
        }
        if (!Double.isNaN(this.avg.auc)) {
            sb.append(String.format(",\n  AUC: %.2f%% \u00b1 %.2f", 100.0 * this.avg.auc, 100.0 * this.sd.auc));
        }
        if (!Double.isNaN(this.avg.logloss)) {
            sb.append(String.format(",\n  log loss: %.4f \u00b1 %.4f", this.avg.logloss, this.sd.logloss));
        } else if (!Double.isNaN(this.avg.crossentropy)) {
            sb.append(String.format(",\n  cross entropy: %.4f \u00b1 %.4f", this.avg.crossentropy, this.sd.crossentropy));
        }
        sb.append("\n}");
        return sb.toString();
    }
}

