/*
 * Decompiled with CFR 0.152.
 */
package smile.projection;

import java.io.Serializable;
import smile.math.MathEx;
import smile.math.blas.UPLO;
import smile.math.matrix.Matrix;
import smile.projection.LinearProjection;

public class ProbabilisticPCA
implements LinearProjection,
Serializable {
    private static final long serialVersionUID = 2L;
    private double[] mu;
    private double[] pmu;
    private double noise;
    private Matrix loading;
    private Matrix projection;

    public ProbabilisticPCA(double noise, double[] mu, Matrix loading, Matrix projection) {
        this.noise = noise;
        this.mu = mu;
        this.loading = loading;
        this.projection = projection;
        this.pmu = new double[projection.nrows()];
        projection.mv(mu, this.pmu);
    }

    public Matrix getLoadings() {
        return this.loading;
    }

    public double[] getCenter() {
        return this.mu;
    }

    public double getNoiseVariance() {
        return this.noise;
    }

    @Override
    public Matrix getProjection() {
        return this.projection;
    }

    @Override
    public double[] project(double[] x) {
        if (x.length != this.mu.length) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.mu.length));
        }
        double[] y = new double[this.projection.nrows()];
        this.projection.mv(x, y);
        MathEx.sub((double[])y, (double[])this.pmu);
        return y;
    }

    @Override
    public double[][] project(double[][] x) {
        if (x[0].length != this.mu.length) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x[0].length, this.mu.length));
        }
        double[][] y = new double[x.length][this.projection.nrows()];
        for (int i = 0; i < x.length; ++i) {
            this.projection.mv(x[i], y[i]);
            MathEx.sub((double[])y[i], (double[])this.pmu);
        }
        return y;
    }

    public static ProbabilisticPCA fit(double[][] data, int k) {
        int m = data.length;
        int n = data[0].length;
        double[] mu = MathEx.colMeans((double[][])data);
        Matrix cov = new Matrix(n, n);
        for (int l = 0; l < m; ++l) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j <= i; ++j) {
                    cov.add(i, j, (data[l][i] - mu[i]) * (data[l][j] - mu[j]));
                }
            }
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                cov.div(i, j, (double)m);
                cov.set(j, i, cov.get(i, j));
            }
        }
        cov.uplo(UPLO.LOWER);
        Matrix.EVD eigen = cov.eigen(false, true, true).sort();
        double[] evalues = eigen.wr;
        Matrix evectors = eigen.Vr;
        double noise = 0.0;
        for (int i = k; i < n; ++i) {
            noise += evalues[i];
        }
        noise /= (double)(n - k);
        Matrix loading = new Matrix(n, k);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < k; ++j) {
                loading.set(i, j, evectors.get(i, j) * Math.sqrt(evalues[j] - noise));
            }
        }
        Matrix M2 = loading.ata();
        for (int i = 0; i < k; ++i) {
            M2.add(i, i, noise);
        }
        Matrix.Cholesky chol = M2.cholesky(true);
        Matrix Mi = chol.inverse();
        Matrix projection = Mi.mt(loading);
        return new ProbabilisticPCA(noise, mu, loading, projection);
    }
}

