/*
 * Decompiled with CFR 0.152.
 */
package smile.projection;

import smile.math.matrix.Matrix;
import smile.projection.Projection;

public interface LinearProjection
extends Projection<double[]> {
    public Matrix getProjection();

    @Override
    default public double[] project(double[] x) {
        Matrix A = this.getProjection();
        int p = A.nrows();
        int n = A.ncols();
        if (x.length != n) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, n));
        }
        double[] y = new double[p];
        A.mv(x, y);
        return y;
    }

    default public double[][] project(double[][] x) {
        Matrix A = this.getProjection();
        int p = A.nrows();
        int n = A.ncols();
        if (x[0].length != n) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x[0].length, n));
        }
        double[][] y = new double[x.length][p];
        for (int i = 0; i < x.length; ++i) {
            A.mv(x[i], y[i]);
        }
        return y;
    }
}

