/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.MathEx;
import smile.stat.distribution.GaussianDistribution;

public class TSNE
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = LoggerFactory.getLogger(TSNE.class);
    public final double[][] coordinates;
    private double eta = 500.0;
    private double momentum = 0.5;
    private double finalMomentum = 0.8;
    private int momentumSwitchIter = 250;
    private double minGain = 0.01;
    private int totalIter = 1;
    private double[][] gains;
    private double[][] D;
    private double[][] P;
    private double[][] Q;
    private double Qsum;

    public TSNE(double[][] X, int d) {
        this(X, d, 20.0, 200.0, 1000);
    }

    public TSNE(double[][] X, int d, double perplexity, double eta, int iterations) {
        this.eta = eta;
        int n = X.length;
        if (X.length == X[0].length) {
            this.D = X;
        } else {
            this.D = new double[n][n];
            MathEx.pdist((Object[])X, (double[][])this.D, MathEx::squaredDistance);
        }
        double[][] Y = this.coordinates = new double[n][d];
        this.gains = new double[n][d];
        GaussianDistribution gaussian = new GaussianDistribution(0.0, 1.0E-4);
        for (int i = 0; i < n; ++i) {
            Arrays.fill(this.gains[i], 1.0);
            double[] Yi = Y[i];
            for (int j = 0; j < d; ++j) {
                Yi[j] = gaussian.rand();
            }
        }
        this.P = this.expd(this.D, perplexity, 0.001);
        this.Q = new double[n][n];
        double Psum = 2 * n;
        for (int i = 0; i < n; ++i) {
            double[] Pi = this.P[i];
            for (int j = 0; j < i; ++j) {
                double p = 12.0 * (Pi[j] + this.P[j][i]) / Psum;
                if (Double.isNaN(p) || p < 1.0E-16) {
                    p = 1.0E-16;
                }
                Pi[j] = p;
                this.P[j][i] = p;
            }
        }
        this.update(iterations);
    }

    public void update(int iterations) {
        double[][] Y = this.coordinates;
        int n = Y.length;
        int d = Y[0].length;
        double[][] dY = new double[n][d];
        double[][] dC = new double[n][d];
        int iter = 1;
        while (iter <= iterations) {
            this.Qsum = this.computeQ(Y, this.Q);
            IntStream.range(0, n).parallel().forEach(i -> this.sne(i, dY[i], dC[i]));
            IntStream.range(0, n).parallel().forEach(i -> {
                double[] Yi = Y[i];
                double[] dYi = dY[i];
                double[] dCi = dC[i];
                double[] g = this.gains[i];
                for (int k = 0; k < d; ++k) {
                    dYi[k] = this.momentum * dYi[k] - this.eta * g[k] * dCi[k];
                    int n = k;
                    Yi[n] = Yi[n] + dYi[k];
                }
            });
            if (this.totalIter == this.momentumSwitchIter) {
                this.momentum = this.finalMomentum;
                for (int i2 = 0; i2 < n; ++i2) {
                    double[] Pi = this.P[i2];
                    int j = 0;
                    while (j < n) {
                        int n2 = j++;
                        Pi[n2] = Pi[n2] / 12.0;
                    }
                }
            }
            if (iter % 100 == 0) {
                double C = IntStream.range(0, n).parallel().mapToDouble(i -> {
                    double[] Pi = this.P[i];
                    double[] Qi = this.Q[i];
                    double Ci = 0.0;
                    for (int j = 0; j < i; ++j) {
                        double p = Pi[j];
                        double q = Qi[j] / this.Qsum;
                        if (Double.isNaN(q) || q < 1.0E-16) {
                            q = 1.0E-16;
                        }
                        Ci += p * MathEx.log2((double)(p / q));
                    }
                    return Ci;
                }).sum();
                logger.info("Error after {} iterations: {}", (Object)this.totalIter, (Object)(2.0 * C));
            }
            ++iter;
            ++this.totalIter;
        }
        double[] colMeans = MathEx.colMeans((double[][])Y);
        IntStream.range(0, n).parallel().forEach(i -> {
            double[] Yi = Y[i];
            for (int j = 0; j < d; ++j) {
                int n = j;
                Yi[n] = Yi[n] - colMeans[j];
            }
        });
    }

    private void sne(int i, double[] dY, double[] dC) {
        double[][] Y = this.coordinates;
        int n = Y.length;
        int d = Y[0].length;
        double[] Yi = Y[i];
        double[] Pi = this.P[i];
        double[] Qi = this.Q[i];
        double[] g = this.gains[i];
        Arrays.fill(dC, 0.0);
        for (int j = 0; j < n; ++j) {
            if (i == j) continue;
            double[] Yj = Y[j];
            double q = Qi[j];
            double z = (Pi[j] - q / this.Qsum) * q;
            for (int k = 0; k < d; ++k) {
                int n2 = k;
                dC[n2] = dC[n2] + 4.0 * (Yi[k] - Yj[k]) * z;
            }
        }
        for (int k = 0; k < d; ++k) {
            double d2 = g[k] = Math.signum(dC[k]) != Math.signum(dY[k]) ? g[k] + 0.2 : g[k] * 0.8;
            if (!(g[k] < this.minGain)) continue;
            g[k] = this.minGain;
        }
    }

    private double[][] expd(double[][] D, double perplexity, double tol) {
        int n = D.length;
        double[][] P = new double[n][n];
        double[] DiSum = MathEx.rowSums((double[][])D);
        IntStream.range(0, n).parallel().forEach(i -> {
            double logU = MathEx.log2((double)perplexity);
            double[] Pi = P[i];
            double[] Di = D[i];
            double beta = Math.sqrt((double)(n - 1) / DiSum[i]);
            double betamin = 0.0;
            double betamax = Double.POSITIVE_INFINITY;
            logger.debug("initial beta[{}] = {}", (Object)i, (Object)beta);
            double Hdiff = Double.MAX_VALUE;
            for (int iter = 0; Math.abs(Hdiff) > tol && iter < 50; ++iter) {
                int j;
                double Pisum = 0.0;
                double H = 0.0;
                for (j = 0; j < n; ++j) {
                    double p;
                    double d = beta * Di[j];
                    Pi[j] = p = Math.exp(-d);
                    Pisum += p;
                    H += p * d;
                }
                Pi[i] = 0.0;
                if (Math.abs(Hdiff = (H = MathEx.log2((double)(Pisum -= 1.0)) + H / Pisum) - logU) > tol) {
                    if (Hdiff > 0.0) {
                        betamin = beta;
                        beta = Double.isInfinite(betamax) ? (beta *= 2.0) : (beta + betamax) / 2.0;
                    } else {
                        betamax = beta;
                        beta = (beta + betamin) / 2.0;
                    }
                } else {
                    j = 0;
                    while (j < n) {
                        int n2 = j++;
                        Pi[n2] = Pi[n2] / Pisum;
                    }
                }
                logger.debug("Hdiff = {}, beta[{}] = {}, H = {}, logU = {}", new Object[]{Hdiff, i, beta, H, logU});
            }
        });
        return P;
    }

    private double computeQ(double[][] x, double[][] Q) {
        int n = x.length;
        return IntStream.range(0, n).parallel().mapToDouble(i -> {
            double[] xi = x[i];
            double[] Qi = Q[i];
            double sum = 0.0;
            for (int j = 0; j < n; ++j) {
                double q;
                Qi[j] = q = 1.0 / (1.0 + MathEx.squaredDistance((double[])xi, (double[])x[j]));
                sum += q;
            }
            return sum;
        }).sum();
    }
}

