/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.graph.AdjacencyList;
import smile.math.distance.Distance;
import smile.math.distance.EuclideanDistance;
import smile.neighbor.LinearSearch;
import smile.neighbor.Neighbor;

class NearestNeighborGraph {
    private static final Logger logger = LoggerFactory.getLogger(NearestNeighborGraph.class);
    public final int[] index;
    public final AdjacencyList graph;

    public NearestNeighborGraph(int[] index, AdjacencyList graph) {
        this.index = index;
        this.graph = graph;
    }

    public static AdjacencyList of(double[][] data, int k, boolean digraph, EdgeConsumer consumer) {
        return NearestNeighborGraph.of(data, new EuclideanDistance(), k, digraph, consumer);
    }

    public static <T> AdjacencyList of(T[] data, Distance<T> distance, int k, boolean digraph, EdgeConsumer consumer) {
        LinearSearch<T> knn = new LinearSearch<T>(data, distance);
        int n = data.length;
        AdjacencyList graph = new AdjacencyList(n, digraph);
        if (consumer != null) {
            for (int i = 0; i < n; ++i) {
                Neighbor<T, T>[] neighbors = knn.knn(data[i], k);
                int v1 = i;
                for (int j = 0; j < neighbors.length; ++j) {
                    int v2 = neighbors[j].index;
                    double weight = neighbors[j].distance;
                    graph.setWeight(v1, v2, weight);
                    consumer.accept(v1, v2, weight, j);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                for (Neighbor<T, T> neighbor : knn.knn(data[i], k)) {
                    graph.setWeight(i, neighbor.index, neighbor.distance);
                }
            }
        }
        return graph;
    }

    public static NearestNeighborGraph largest(AdjacencyList graph) {
        int[] index;
        int n = graph.getNumVertices();
        int[][] cc = graph.bfs();
        if (cc.length == 1) {
            index = new int[n];
            for (int i = 0; i < n; ++i) {
                index[i] = i;
            }
        } else {
            n = 0;
            int largest = 0;
            for (int i = 0; i < cc.length; ++i) {
                if (cc[i].length <= n) continue;
                largest = i;
                n = cc[i].length;
            }
            logger.info("{} connected components, largest one has {} samples.", (Object)cc.length, (Object)n);
            index = cc[largest];
            graph = graph.subgraph(index);
        }
        return new NearestNeighborGraph(index, graph);
    }

    public static interface EdgeConsumer {
        public void accept(int var1, int var2, double var3, int var5);
    }
}

