/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import smile.data.SparseDataset;
import smile.graph.AdjacencyList;
import smile.graph.Graph;
import smile.manifold.NearestNeighborGraph;
import smile.math.distance.Distance;
import smile.math.distance.EuclideanDistance;
import smile.math.matrix.ARPACK;
import smile.math.matrix.DMatrix;
import smile.math.matrix.Matrix;
import smile.math.matrix.SparseMatrix;
import smile.util.SparseArray;

public class LaplacianEigenmap
implements Serializable {
    private static final long serialVersionUID = 2L;
    public final double width;
    public final int[] index;
    public final double[][] coordinates;
    public final AdjacencyList graph;

    public LaplacianEigenmap(int[] index, double[][] coordinates, AdjacencyList graph) {
        this(-1.0, index, coordinates, graph);
    }

    public LaplacianEigenmap(double width, int[] index, double[][] coordinates, AdjacencyList graph) {
        this.width = width;
        this.index = index;
        this.coordinates = coordinates;
        this.graph = graph;
    }

    public static LaplacianEigenmap of(double[][] data, int k) {
        return LaplacianEigenmap.of(data, k, 2, -1.0);
    }

    public static LaplacianEigenmap of(double[][] data, int k, int d, double t) {
        return LaplacianEigenmap.of(data, new EuclideanDistance(), k, d, t);
    }

    public static <T> LaplacianEigenmap of(T[] data, Distance<T> distance, int k) {
        return LaplacianEigenmap.of(data, distance, k, 2, -1.0);
    }

    public static <T> LaplacianEigenmap of(T[] data, Distance<T> distance, int k, int d, double t) {
        SparseArray row;
        int i;
        AdjacencyList graph = NearestNeighborGraph.of(data, distance, k, false, null);
        NearestNeighborGraph nng = NearestNeighborGraph.largest(graph);
        int[] index = nng.index;
        int n = index.length;
        graph = nng.graph;
        double[] D = new double[n];
        double gamma = -1.0 / t;
        ArrayList<SparseArray> W = new ArrayList<SparseArray>(n);
        for (i = 0; i < n; ++i) {
            row = new SparseArray();
            Collection edges = graph.getEdges(i);
            Iterator iterator = edges.iterator();
            while (iterator.hasNext()) {
                Graph.Edge edge = (Graph.Edge)iterator.next();
                int j = edge.v2;
                if (i == j) {
                    j = edge.v1;
                }
                double w = t <= 0.0 ? 1.0 : Math.exp(gamma * edge.weight * edge.weight);
                row.set(j, w);
                int n2 = i;
                D[n2] = D[n2] + w;
            }
            D[i] = 1.0 / Math.sqrt(D[i]);
            W.add(i, row);
        }
        for (i = 0; i < n; ++i) {
            row = (SparseArray)W.get(i);
            for (SparseArray.Entry e : row) {
                e.update(-D[i] * e.x * D[e.i]);
            }
            row.set(i, 1.0);
        }
        SparseMatrix L = SparseDataset.of(W, (int)n).toMatrix();
        Matrix.EVD eigen = ARPACK.syev((DMatrix)L, (ARPACK.SymmOption)ARPACK.SymmOption.SM, (int)Math.min(10 * (d + 1), n - 1));
        Matrix V = eigen.Vr;
        double[][] coordinates = new double[n][d];
        int j = d;
        while (--j >= 0) {
            int i2;
            double norm = 0.0;
            int c = V.ncols() - j - 2;
            for (i2 = 0; i2 < n; ++i2) {
                double xi;
                coordinates[i2][j] = xi = V.get(i2, c) * D[i2];
                norm += xi * xi;
            }
            norm = Math.sqrt(norm);
            for (i2 = 0; i2 < n; ++i2) {
                double[] dArray = coordinates[i2];
                int n3 = j;
                dArray[n3] = dArray[n3] / norm;
            }
        }
        return new LaplacianEigenmap(t, index, coordinates, graph);
    }
}

