/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import java.util.HashMap;
import java.util.Map;

public class Bag {
    private Map<String, Integer> words;
    private boolean binary;

    public Bag(String[] words) {
        this(words, false);
    }

    public Bag(String[] words, boolean binary) {
        this.binary = binary;
        this.words = new HashMap<String, Integer>();
        for (int i = 0; i < words.length; ++i) {
            if (this.words.containsKey(words[i])) {
                throw new IllegalArgumentException("Duplicated word:" + words[i]);
            }
            this.words.put(words[i], i);
        }
    }

    public int[] apply(String[] x) {
        int[] bag = new int[this.words.size()];
        if (this.binary) {
            for (String word : x) {
                Integer f = this.words.get(word);
                if (f == null) continue;
                bag[f.intValue()] = 1;
            }
        } else {
            for (String word : x) {
                Integer f = this.words.get(word);
                if (f == null) continue;
                int n = f;
                bag[n] = bag[n] + 1;
            }
        }
        return bag;
    }
}

