/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor.lsh;

import java.io.Serializable;
import smile.math.MathEx;
import smile.neighbor.lsh.Bucket;
import smile.tensor.DenseMatrix;
import smile.tensor.ScalarType;
import smile.tensor.Vector;

public class Hash
implements Serializable {
    private static final long serialVersionUID = 2L;
    final int MAX_HASH_RND = 0x20000000;
    final int P = Integer.MAX_VALUE;
    int H;
    int d;
    int k;
    double w;
    int[] c;
    DenseMatrix a;
    double[] b;
    Bucket[] table;

    public Hash(int d, int k, double w, int H) {
        int i;
        if (d < 2) {
            throw new IllegalArgumentException("Invalid input space dimension: " + d);
        }
        if (k < 1) {
            throw new IllegalArgumentException("Invalid number of random projections per hash value: " + k);
        }
        if (w <= 0.0) {
            throw new IllegalArgumentException("Invalid width of random projections: " + w);
        }
        if (H < 1) {
            throw new IllegalArgumentException("Invalid size of hash tables: " + H);
        }
        this.d = d;
        this.k = k;
        this.w = w;
        this.H = H;
        this.a = DenseMatrix.randn(ScalarType.Float64, k, d);
        this.b = new double[k];
        for (i = 0; i < k; ++i) {
            this.b[i] = MathEx.random(0.0, w);
        }
        this.c = new int[k];
        for (i = 0; i < k; ++i) {
            this.c[i] = MathEx.randomInt(0x20000000);
        }
        this.table = new Bucket[H];
    }

    double hash(double[] x, int i) {
        double g = this.b[i];
        for (int j = 0; j < this.d; ++j) {
            g += this.a.get(i, j) * x[j];
        }
        return g / this.w;
    }

    public int hash(double[] x) {
        Vector h = this.a.mv(x);
        long g = 0L;
        for (int i = 0; i < this.k; ++i) {
            int hi = (int)Math.floor((h.get(i) + this.b[i]) / this.w);
            g += (long)this.c[i] * (long)hi;
        }
        int gint = (int)(g % Integer.MAX_VALUE);
        return gint >= 0 ? gint : gint + Integer.MAX_VALUE;
    }

    public void add(int index, double[] x) {
        int bucket = this.hash(x);
        int i = bucket % this.H;
        if (this.table[i] == null) {
            this.table[i] = new Bucket(bucket);
        }
        this.table[i].add(index);
    }

    public Bucket get(int i) {
        return this.table[i % this.H];
    }

    public Bucket get(double[] x) {
        return this.table[this.hash(x) % this.H];
    }
}

