/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.kernel.IsotropicKernel;

public class Matern
implements IsotropicKernel {
    private static final long serialVersionUID = 2L;
    private static final double SQRT3 = Math.sqrt(3.0);
    private static final double SQRT5 = Math.sqrt(5.0);
    final double sigma;
    final double nu;
    final double lo;
    final double hi;

    public Matern(double sigma, double nu, double lo, double hi) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("The length scale is not positive: " + sigma);
        }
        if (nu != 1.5 && nu != 2.5 && nu != 0.5 && !Double.isInfinite(nu)) {
            throw new IllegalArgumentException("nu must be 0.5, 1.5, 2.5 or Info: " + nu);
        }
        this.sigma = sigma;
        this.nu = nu;
        this.lo = lo;
        this.hi = hi;
    }

    public double scale() {
        return this.sigma;
    }

    public double smoothness() {
        return this.nu;
    }

    public String toString() {
        return String.format("MaternKernel(%.4f, %.1f)", this.sigma, this.nu);
    }

    @Override
    public double f(double dist) {
        return this.k(dist);
    }

    @Override
    public double k(double dist) {
        double d = dist / this.sigma;
        if (this.nu == 1.5) {
            return (1.0 + (d *= SQRT3)) * Math.exp(-d);
        }
        if (this.nu == 2.5) {
            return (1.0 + (d *= SQRT5) + d * d / 3.0) * Math.exp(-d);
        }
        if (this.nu == 0.5) {
            return Math.exp(-d);
        }
        if (Double.isInfinite(this.nu)) {
            return Math.exp(-0.5 * d * d);
        }
        throw new IllegalStateException("Unsupported nu = " + this.nu);
    }

    @Override
    public double[] kg(double dist) {
        double g;
        double k;
        double d = dist / this.sigma;
        if (this.nu == 1.5) {
            k = (1.0 + (d *= SQRT3)) * Math.exp(-d);
            g = (2.0 + d) * Math.exp(-d) * d / this.sigma;
        } else if (this.nu == 2.5) {
            k = (1.0 + (d *= SQRT5) + d * d / 3.0) * Math.exp(-d);
            g = (2.0 + 5.0 * d / 3.0 + d * d / 3.0) * Math.exp(-d) * d / this.sigma;
        } else if (this.nu == 0.5) {
            k = Math.exp(-d);
            g = k * d / this.sigma;
        } else if (Double.isInfinite(this.nu)) {
            k = Math.exp(-0.5 * d * d);
            g = k * d * d / this.sigma;
        } else {
            throw new IllegalStateException("Unsupported nu = " + this.nu);
        }
        return new double[]{k, g};
    }
}

