/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.csv.CSVFormat;
import smile.data.DataFrame;
import smile.io.Arff;
import smile.io.Arrow;
import smile.io.CSV;

public interface Write {
    public static Path object(Serializable o) throws IOException {
        Path temp = Files.createTempFile("smile-test-", ".tmp", new FileAttribute[0]);
        Write.object(o, temp);
        temp.toFile().deleteOnExit();
        return temp;
    }

    public static void object(Serializable o, Path path) throws IOException {
        OutputStream file = Files.newOutputStream(path, new OpenOption[0]);
        ObjectOutputStream out = new ObjectOutputStream(file);
        out.writeObject(o);
        out.close();
        file.close();
    }

    public static void csv(DataFrame data, Path path) throws IOException {
        Write.csv(data, path, CSVFormat.DEFAULT);
    }

    public static void csv(DataFrame data, Path path, CSVFormat format) throws IOException {
        CSV csv = new CSV(format);
        csv.write(data, path);
    }

    public static void arrow(DataFrame data, Path path) throws IOException {
        Arrow arrow = new Arrow();
        arrow.write(data, path);
    }

    public static void arff(DataFrame data, Path path, String relation) throws IOException {
        Arff.write(data, path, relation);
    }
}

