/*
 * Decompiled with CFR 0.152.
 */
package smile.interpolation;

import smile.interpolation.variogram.PowerVariogram;
import smile.interpolation.variogram.Variogram;
import smile.linalg.UPLO;
import smile.tensor.DenseMatrix;
import smile.tensor.SVD;
import smile.tensor.ScalarType;

public class KrigingInterpolation {
    private final double[][] x;
    private final Variogram variogram;
    private final double[] yvi;

    public KrigingInterpolation(double[][] x, double[] y) {
        this(x, y, new PowerVariogram(x, y), null);
    }

    public KrigingInterpolation(double[][] x, double[] y, Variogram variogram, double[] error) {
        int i;
        this.x = x;
        this.variogram = variogram;
        int n = x.length;
        double[] yv = new double[n + 1];
        DenseMatrix v = DenseMatrix.zeros(ScalarType.Float64, n + 1, n + 1);
        v.withUplo(UPLO.LOWER);
        for (i = 0; i < n; ++i) {
            yv[i] = y[i];
            for (int j = i; j < n; ++j) {
                double var = variogram.f(this.rdist(x[i], x[j]));
                v.set(i, j, var);
                v.set(j, i, var);
            }
            v.set(n, i, 1.0);
            v.set(i, n, 1.0);
        }
        yv[n] = 0.0;
        v.set(n, n, 0.0);
        if (error != null) {
            for (i = 0; i < n; ++i) {
                v.sub(i, i, error[i] * error[i]);
            }
        }
        SVD svd = v.svd(true);
        this.yvi = svd.solve(yv).toArray(new double[0]);
    }

    public double interpolate(double ... x) {
        if (x.length != this.x[0].length) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.x[0].length));
        }
        int n = this.x.length;
        double y = this.yvi[n];
        for (int i = 0; i < n; ++i) {
            y += this.yvi[i] * this.variogram.f(this.rdist(x, this.x[i]));
        }
        return y;
    }

    private double rdist(double[] x1, double[] x2) {
        double d = 0.0;
        for (int i = 0; i < x1.length; ++i) {
            double t2 = x1[i] - x2[i];
            d += t2 * t2;
        }
        return Math.sqrt(d);
    }

    public String toString() {
        return String.format("Kriging Interpolation(%s)", this.variogram);
    }
}

