/*
 * Decompiled with CFR 0.152.
 */
package smile.datasets;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.csv.CSVFormat;
import smile.data.CategoricalEncoder;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.io.Paths;
import smile.io.Read;

public record LibrasMovement(DataFrame data, Formula formula) {
    public LibrasMovement() throws IOException {
        this(Paths.getTestData("classification/movement_libras.data"));
    }

    public LibrasMovement(Path path) throws IOException {
        this(Read.csv(path, CSVFormat.DEFAULT), Formula.lhs("V91"));
    }

    public double[][] x() {
        return this.formula.x(this.data).toArray(false, CategoricalEncoder.DUMMY, new String[0]);
    }

    public int[] y() {
        return this.formula.y(this.data).intStream().map(yi -> yi - 1).toArray();
    }
}

