/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import smile.data.measure.CategoricalMeasure;
import smile.data.measure.NominalScale;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.ByteVector;
import smile.data.vector.IntVector;
import smile.data.vector.ObjectVector;
import smile.data.vector.ShortVector;
import smile.data.vector.ValueVector;
import smile.util.Index;

public class StringVector
extends ObjectVector<String> {
    public StringVector(String name, String[] vector) {
        this(new StructField(name, DataTypes.StringType), vector);
    }

    public StringVector(StructField field, String[] vector) {
        if (field.dtype() != DataTypes.StringType) {
            throw new IllegalArgumentException("Invalid data type: " + String.valueOf(field));
        }
        super(field, vector);
    }

    public NominalScale nominal() {
        List<String> levels = this.distinct();
        Collections.sort(levels);
        return new NominalScale(levels);
    }

    public ValueVector factorize(CategoricalMeasure scale) {
        switch (scale.type().id()) {
            case Byte: {
                byte[] data = new byte[this.size()];
                for (int i = 0; i < data.length; ++i) {
                    String s = (String)this.get(i);
                    data[i] = s == null ? -1 : (int)scale.valueOf(s).byteValue();
                }
                StructField field = new StructField(this.name(), DataTypes.ByteType, scale);
                return new ByteVector(field, data);
            }
            case Short: {
                short[] data = new short[this.size()];
                for (int i = 0; i < data.length; ++i) {
                    String s = (String)this.get(i);
                    data[i] = s == null ? -1 : (int)scale.valueOf(s).shortValue();
                }
                StructField field = new StructField(this.name(), DataTypes.ShortType, scale);
                return new ShortVector(field, data);
            }
            case Int: {
                int[] data = new int[this.size()];
                for (int i = 0; i < data.length; ++i) {
                    String s = (String)this.get(i);
                    data[i] = s == null ? -1 : scale.valueOf(s).intValue();
                }
                StructField field = new StructField(this.name(), DataTypes.IntType, scale);
                return new IntVector(field, data);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type for nominal measure: " + String.valueOf(scale.type()));
    }

    @Override
    public StringVector get(Index index) {
        String[] data = new String[index.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = ((String[])this.vector)[index.apply(i)];
        }
        return new StringVector(this.field, data);
    }

    @Override
    public StringVector withName(String name) {
        return new StringVector(this.field.withName(name), (String[])this.vector);
    }

    @Override
    public IntStream intStream() {
        return Arrays.stream((String[])this.vector).filter(Objects::nonNull).mapToInt(Integer::parseInt);
    }

    @Override
    public LongStream longStream() {
        return Arrays.stream((String[])this.vector).filter(Objects::nonNull).mapToLong(Long::parseLong);
    }

    @Override
    public DoubleStream doubleStream() {
        return Arrays.stream((String[])this.vector).filter(Objects::nonNull).mapToDouble(Double::parseDouble);
    }

    @Override
    public boolean getBoolean(int i) {
        return Boolean.parseBoolean(((String[])this.vector)[i]);
    }

    @Override
    public char getChar(int i) {
        String s = ((String[])this.vector)[i];
        return s.isEmpty() ? (char)'\u0000' : s.charAt(0);
    }

    @Override
    public byte getByte(int i) {
        return Byte.parseByte(((String[])this.vector)[i]);
    }

    @Override
    public short getShort(int i) {
        return Short.parseShort(((String[])this.vector)[i]);
    }

    @Override
    public int getInt(int i) {
        return Integer.parseInt(((String[])this.vector)[i]);
    }

    @Override
    public long getLong(int i) {
        return Long.parseLong(((String[])this.vector)[i]);
    }

    @Override
    public float getFloat(int i) {
        return Float.parseFloat(((String[])this.vector)[i]);
    }

    @Override
    public double getDouble(int i) {
        return Double.parseDouble(((String[])this.vector)[i]);
    }
}

