/*
 * Decompiled with CFR 0.152.
 */
package smile.data.type;

import java.util.Arrays;
import smile.data.type.DataType;
import smile.data.type.DataTypes;

public class ArrayType
implements DataType {
    static final ArrayType BooleanArrayType = new ArrayType(DataTypes.BooleanType);
    static final ArrayType CharArrayType = new ArrayType(DataTypes.CharType);
    static final ArrayType ByteArrayType = new ArrayType(DataTypes.ByteType);
    static final ArrayType ShortArrayType = new ArrayType(DataTypes.ShortType);
    static final ArrayType IntArrayType = new ArrayType(DataTypes.IntType);
    static final ArrayType LongArrayType = new ArrayType(DataTypes.LongType);
    static final ArrayType FloatArrayType = new ArrayType(DataTypes.FloatType);
    static final ArrayType DoubleArrayType = new ArrayType(DataTypes.DoubleType);
    private final DataType type;

    ArrayType(DataType type) {
        this.type = type;
    }

    public DataType getComponentType() {
        return this.type;
    }

    @Override
    public String name() {
        return String.format("Array[%s]", this.type.name());
    }

    @Override
    public DataType.ID id() {
        return DataType.ID.Array;
    }

    public String toString() {
        return String.format("%s[]", this.type);
    }

    @Override
    public String toString(Object o) {
        return switch (this.type.id()) {
            case DataType.ID.Boolean -> Arrays.toString((boolean[])o);
            case DataType.ID.Byte -> Arrays.toString((byte[])o);
            case DataType.ID.Char -> Arrays.toString((char[])o);
            case DataType.ID.Short -> Arrays.toString((short[])o);
            case DataType.ID.Int -> Arrays.toString((int[])o);
            case DataType.ID.Long -> Arrays.toString((long[])o);
            case DataType.ID.Float -> Arrays.toString((float[])o);
            case DataType.ID.Double -> Arrays.toString((double[])o);
            default -> Arrays.toString((Object[])o);
        };
    }

    public Object[] valueOf(String s) {
        String[] elements = s.substring(1, s.length() - 1).split(",");
        Object[] array = new Object[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            array[i] = this.type.valueOf(elements[i]);
        }
        return array;
    }

    public boolean equals(Object o) {
        if (o instanceof ArrayType) {
            return this.type == ((ArrayType)o).getComponentType();
        }
        return false;
    }
}

