/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.MathEx;
import smile.math.kernel.MercerKernel;

public class PearsonKernel
implements MercerKernel<double[]> {
    private static final long serialVersionUID = 2L;
    private final double omega;
    private final double sigma;
    private final double C;
    private final double lo;
    private final double hi;

    public PearsonKernel(double sigma, double omega) {
        this(sigma, omega, 1.0E-5, 100000.0);
    }

    public PearsonKernel(double sigma, double omega, double lo, double hi) {
        this.omega = omega;
        this.sigma = sigma;
        this.C = 4.0 * (Math.pow(2.0, 1.0 / omega) - 1.0) / (sigma * sigma);
        this.lo = lo;
        this.hi = hi;
    }

    public double sigma() {
        return this.sigma;
    }

    public double omega() {
        return this.omega;
    }

    public String toString() {
        return String.format("PearsonKernel(%.4f, %.4f)", this.sigma, this.omega);
    }

    @Override
    public double k(double[] x, double[] y) {
        double d = MathEx.squaredDistance(x, y);
        return Math.pow(1.0 + this.C * d, -this.omega);
    }

    @Override
    public double[] kg(double[] x, double[] y) {
        double d = MathEx.squaredDistance(x, y);
        double[] g = new double[]{Math.pow(1.0 + this.C * d, -this.omega), -2.0 * this.C * d * Math.pow(1.0 + this.C * d, -this.omega - 1.0) / this.sigma};
        return g;
    }

    public PearsonKernel of(double[] params) {
        return new PearsonKernel(params[0], this.omega, this.lo, this.hi);
    }

    @Override
    public double[] hyperparameters() {
        return new double[]{this.sigma};
    }

    @Override
    public double[] lo() {
        return new double[]{this.lo};
    }

    @Override
    public double[] hi() {
        return new double[]{this.hi};
    }
}

