/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="install-node-and-npm", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public final class InstallNodeAndNpmMojo
extends AbstractFrontendMojo {
    @Parameter(property="nodeDownloadRoot", required=false, defaultValue="http://nodejs.org/dist/")
    private String nodeDownloadRoot;
    @Parameter(property="npmDownloadRoot", required=false, defaultValue="http://registry.npmjs.org/npm/-/")
    private String npmDownloadRoot;
    @Deprecated
    @Parameter(property="downloadRoot", required=false, defaultValue="")
    private String downloadRoot;
    @Parameter(property="nodeVersion", required=true)
    private String nodeVersion;
    @Parameter(property="npmVersion", required=true)
    private String npmVersion;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="skip.installnodenpm", defaultValue="false")
    private Boolean skip;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    @Override
    public void execute(FrontendPluginFactory factory) throws InstallationException {
        ProxyConfig proxyConfig = MojoUtils.getProxyConfig(this.session, this.decrypter);
        String nodeDownloadRoot = this.getNodeDownloadRoot();
        String npmDownloadRoot = this.getNpmDownloadRoot();
        factory.getNodeAndNPMInstaller(proxyConfig).install(this.nodeVersion, this.npmVersion, nodeDownloadRoot, npmDownloadRoot);
    }

    private String getNodeDownloadRoot() {
        if (this.downloadRoot != null && !"".equals(this.downloadRoot) && "http://nodejs.org/dist/".equals(this.nodeDownloadRoot)) {
            return this.downloadRoot;
        }
        return this.nodeDownloadRoot;
    }

    private String getNpmDownloadRoot() {
        if (this.downloadRoot != null && !"".equals(this.downloadRoot) && "http://registry.npmjs.org/npm/-/".equals(this.npmDownloadRoot)) {
            return this.downloadRoot;
        }
        return this.npmDownloadRoot;
    }
}

