/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.TaskRunnerException;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="gulp", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public final class GulpMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}", property="workingDirectory", required=false)
    private File workingDirectory;
    @Parameter(property="frontend.gulp.arguments")
    private String arguments;
    @Parameter(property="triggerfiles")
    private File[] triggerfiles;
    @Parameter(property="srcdir")
    private File srcdir;
    @Parameter(property="outputdir")
    private File outputdir;
    @Parameter(property="skip.gulp", defaultValue="false")
    private Boolean skip;
    @Component
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.shouldExecute()) {
            try {
                MojoUtils.setSLF4jLogger(this.getLog());
                new FrontendPluginFactory(this.workingDirectory).getGulpRunner().execute(this.arguments);
            }
            catch (TaskRunnerException e) {
                throw new MojoFailureException("Failed to run task", (Throwable)e);
            }
            if (this.outputdir != null) {
                this.getLog().info((CharSequence)("Refreshing files after gulp: " + this.outputdir));
                this.buildContext.refresh(this.outputdir);
            }
        } else {
            this.getLog().info((CharSequence)("Skipping gulp as no modified files in " + this.srcdir));
        }
    }

    private boolean shouldExecute() {
        if (this.skip.booleanValue()) {
            return false;
        }
        if (this.buildContext == null || !this.buildContext.isIncremental()) {
            return true;
        }
        if (this.triggerfiles != null) {
            for (int i = 0; i < this.triggerfiles.length; ++i) {
                if (!this.buildContext.hasDelta(this.triggerfiles[i])) continue;
                return true;
            }
        } else if (this.buildContext.hasDelta(new File(this.workingDirectory, "gulpfile.js"))) {
            return true;
        }
        if (this.srcdir == null) {
            this.getLog().info((CharSequence)"gulp goal doesn't have srcdir set: not checking for modified files");
            return true;
        }
        Scanner scanner = this.buildContext.newScanner(this.srcdir);
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        return includedFiles != null && includedFiles.length > 0;
    }
}

