/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="install-node-and-npm", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public final class InstallNodeAndNpmMojo
extends AbstractMojo {
    @Parameter(property="workingDirectory", defaultValue="${basedir}")
    private File workingDirectory;
    @Parameter(property="nodeDownloadRoot", required=false, defaultValue="http://nodejs.org/dist/")
    private String nodeDownloadRoot;
    @Parameter(property="npmDownloadRoot", required=false, defaultValue="http://registry.npmjs.org/npm/-/")
    private String npmDownloadRoot;
    @Deprecated
    @Parameter(property="downloadRoot", required=false, defaultValue="")
    private String downloadRoot;
    @Parameter(property="nodeVersion", required=true)
    private String nodeVersion;
    @Parameter(property="npmVersion", required=true)
    private String npmVersion;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            MojoUtils.setSLF4jLogger(this.getLog());
            ProxyConfig proxyConfig = MojoUtils.getProxyConfig(this.session);
            String nodeDownloadRoot = this.getNodeDownloadRoot();
            String npmDownloadRoot = this.getNpmDownloadRoot();
            new FrontendPluginFactory(this.workingDirectory, proxyConfig).getNodeAndNPMInstaller().install(this.nodeVersion, this.npmVersion, nodeDownloadRoot, npmDownloadRoot);
        }
        catch (InstallationException e) {
            throw MojoUtils.toMojoFailureException(e);
        }
    }

    private String getNodeDownloadRoot() {
        if (this.downloadRoot != null && !"".equals(this.downloadRoot) && "http://nodejs.org/dist/".equals(this.nodeDownloadRoot)) {
            return this.downloadRoot;
        }
        return this.nodeDownloadRoot;
    }

    private String getNpmDownloadRoot() {
        if (this.downloadRoot != null && !"".equals(this.downloadRoot) && "http://registry.npmjs.org/npm/-/".equals(this.npmDownloadRoot)) {
            return this.downloadRoot;
        }
        return this.npmDownloadRoot;
    }
}

