/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bigsorter;

import com.github.davidmoten.bigsorter.NonClosingInputStream;
import com.github.davidmoten.bigsorter.Reader;
import com.github.davidmoten.bigsorter.Serializer;
import com.github.davidmoten.bigsorter.Util;
import com.github.davidmoten.bigsorter.Writer;
import com.github.davidmoten.guavamini.Lists;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Sorter<T> {
    private final List<Supplier<? extends InputStream>> inputs;
    private final Serializer<T> serializer;
    private final File output;
    private final Comparator<? super T> comparator;
    private final int maxFilesPerMerge;
    private final int maxItemsPerPart;
    private final Consumer<? super String> log;
    private final int bufferSize;
    private final File tempDirectory;
    private final Function<? super Reader<T>, ? extends Reader<? extends T>> transform;
    private final boolean unique;
    private long count = 0L;

    Sorter(List<Supplier<? extends InputStream>> inputs, Serializer<T> serializer, File output, Comparator<? super T> comparator, int maxFilesPerMerge, int maxItemsPerFile, Consumer<? super String> log, int bufferSize, File tempDirectory, Function<? super Reader<T>, ? extends Reader<? extends T>> transform, boolean unique) {
        Preconditions.checkNotNull(inputs, (String)"inputs cannot be null");
        Preconditions.checkNotNull(serializer, (String)"serializer cannot be null");
        Preconditions.checkNotNull((Object)output, (String)"output cannot be null");
        Preconditions.checkNotNull(comparator, (String)"comparator cannot be null");
        Preconditions.checkNotNull(transform, (String)"transform cannot be null");
        this.inputs = inputs;
        this.serializer = serializer;
        this.output = output;
        this.comparator = comparator;
        this.maxFilesPerMerge = maxFilesPerMerge;
        this.maxItemsPerPart = maxItemsPerFile;
        this.log = log;
        this.bufferSize = bufferSize;
        this.tempDirectory = tempDirectory;
        this.transform = transform;
        this.unique = unique;
    }

    public static <T> Builder<T> serializer(Serializer<T> serializer) {
        Preconditions.checkNotNull(serializer, (String)"serializer cannot be null");
        return new Builder<T>(serializer);
    }

    public static <T> Builder<String> serializerLinesUtf8() {
        return Sorter.serializer(Serializer.linesUtf8());
    }

    public static <T> Builder<String> serializerLines(Charset charset) {
        return Sorter.serializer(Serializer.lines(charset));
    }

    public static <T> Builder2<String> lines(Charset charset) {
        return Sorter.serializer(Serializer.lines(charset)).comparator(Comparator.naturalOrder());
    }

    public static <T> Builder2<String> linesUtf8() {
        return Sorter.serializer(Serializer.linesUtf8()).comparator(Comparator.naturalOrder());
    }

    static InputStream openFile(File file, int bufferSize) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file), bufferSize);
    }

    private void log(String msg, Object ... objects) {
        if (this.log != null) {
            String s = String.format(msg, objects);
            this.log.accept(s);
        }
    }

    private File sort() throws IOException {
        this.tempDirectory.mkdirs();
        long time = System.currentTimeMillis();
        this.count = 0L;
        ArrayList<File> files = new ArrayList<File>();
        this.log("starting sort", new Object[0]);
        this.log("unique = " + this.unique, new Object[0]);
        int i = 0;
        ArrayList<T> list = new ArrayList<T>();
        for (Supplier<? extends InputStream> supplier : this.inputs) {
            InputStream in = supplier.get();
            Throwable throwable = null;
            try {
                Reader<T> reader = this.transform.apply(this.serializer.createReader(in));
                Throwable throwable2 = null;
                try {
                    T t;
                    do {
                        if ((t = reader.read()) != null) {
                            list.add(t);
                            ++i;
                        }
                        if (t != null && i != this.maxItemsPerPart) continue;
                        i = 0;
                        if (list.size() <= 0) continue;
                        File f = this.sortAndWriteToFile(list);
                        files.add(f);
                        list.clear();
                    } while (t != null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable2 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                in.close();
            }
        }
        this.log("completed inital split and sort, starting merge", new Object[0]);
        File result = this.merge(files);
        Files.move(result.toPath(), this.output.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        this.log("sort of " + this.count + " records completed in " + (double)(System.currentTimeMillis() - time) / 1000.0 + "s", new Object[0]);
        return this.output;
    }

    @VisibleForTesting
    File merge(List<File> files) {
        try {
            File result;
            while (files.size() > 1) {
                ArrayList<File> nextRound = new ArrayList<File>();
                for (int i = 0; i < files.size(); i += this.maxFilesPerMerge) {
                    File merged = this.mergeGroup(files.subList(i, Math.min(files.size(), i + this.maxFilesPerMerge)));
                    nextRound.add(merged);
                }
                files = nextRound;
            }
            if (files.isEmpty()) {
                this.output.delete();
                this.output.createNewFile();
                result = this.output;
            } else {
                result = files.get(0);
            }
            return result;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private File mergeGroup(List<File> list) throws IOException {
        this.log("merging %s files", list.size());
        if (list.size() == 1) {
            return list.get(0);
        }
        ArrayList<State<T>> states = new ArrayList<State<T>>();
        for (File f : list) {
            State<T> st = this.createState(f);
            states.add(st);
        }
        File output = this.nextTempFile();
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(output), this.bufferSize);
             Writer writer = this.serializer.createWriter(out);){
            PriorityQueue<State> q = new PriorityQueue<State>((x, y) -> this.comparator.compare(x.value, y.value));
            q.addAll(states);
            Object last = null;
            while (!q.isEmpty()) {
                State state = (State)q.poll();
                if (!this.unique || last == null || this.comparator.compare(state.value, last) != 0) {
                    writer.write(state.value);
                    last = state.value;
                }
                state.value = state.reader.readAutoClosing();
                if (state.value != null) {
                    q.offer(state);
                    continue;
                }
                state.file.delete();
            }
        }
        return output;
    }

    private State<T> createState(File f) throws IOException {
        InputStream in = Sorter.openFile(f, this.bufferSize);
        Reader<T> reader = this.serializer.createReader(in);
        T t = reader.readAutoClosing();
        return new State<T>(f, reader, t);
    }

    private File sortAndWriteToFile(ArrayList<T> list) throws FileNotFoundException, IOException {
        File file = this.nextTempFile();
        long t = System.currentTimeMillis();
        list.sort(this.comparator);
        this.writeToFile(list, file);
        DecimalFormat df = new DecimalFormat("0.000");
        this.count += (long)list.size();
        this.log("total=%s, sorted %s records to file %s in %ss", this.count, list.size(), file.getName(), df.format((double)(System.currentTimeMillis() - t) / 1000.0));
        return file;
    }

    private void writeToFile(List<T> list, File f) throws FileNotFoundException, IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f), this.bufferSize);
             Writer<T> writer = this.serializer.createWriter(out);){
            Object last = null;
            for (T t : list) {
                if (this.unique && last != null && this.comparator.compare(t, last) == 0) continue;
                writer.write(t);
                last = t;
            }
        }
    }

    private File nextTempFile() throws IOException {
        return Sorter.nextTempFile(this.tempDirectory);
    }

    private static File nextTempFile(File tempDirectory) throws IOException {
        return File.createTempFile("big-sorter", "", tempDirectory);
    }

    private static final class State<T> {
        final File file;
        Reader<T> reader;
        T value;

        State(File file, Reader<T> reader, T value) {
            this.file = file;
            this.reader = reader;
            this.value = value;
        }
    }

    public static final class Builder5<T> {
        private final Builder<T> b;

        Builder5(Builder<T> b) {
            this.b = b;
        }

        public Stream<T> sort() {
            try {
                ((Builder)this.b).output = Sorter.nextTempFile(((Builder)this.b).tempDirectory);
                Sorter sorter = new Sorter(((Builder)this.b).inputs, ((Builder)this.b).serializer, ((Builder)this.b).output, ((Builder)this.b).comparator, ((Builder)this.b).maxFilesPerMerge, ((Builder)this.b).maxItemsPerFile, ((Builder)this.b).logger, ((Builder)this.b).bufferSize, ((Builder)this.b).tempDirectory, ((Builder)this.b).transform, this.b.unique);
                sorter.sort();
                return (Stream)((Builder)this.b).serializer.createReader(((Builder)this.b).output).stream().onClose(() -> ((Builder)this.b).output.delete());
            }
            catch (Throwable e) {
                ((Builder)this.b).output.delete();
                throw Util.toRuntimeException(e);
            }
        }
    }

    public static final class Builder4<T>
    extends Builder4Base<T, Builder4<T>> {
        Builder4(Builder<T> b) {
            super(b);
        }

        public void sort() {
            Sorter sorter = new Sorter(this.b.inputs, this.b.serializer, this.b.output, this.b.comparator, this.b.maxFilesPerMerge, this.b.maxItemsPerFile, this.b.logger, this.b.bufferSize, this.b.tempDirectory, this.b.transform, this.b.unique);
            try {
                sorter.sort();
            }
            catch (IOException e) {
                this.b.output.delete();
                throw new UncheckedIOException(e);
            }
        }
    }

    public static class Builder4Base<T, S extends Builder4Base<T, S>> {
        protected final Builder<T> b;

        Builder4Base(Builder<T> b) {
            this.b = b;
        }

        public S maxFilesPerMerge(int value) {
            Preconditions.checkArgument((value > 1 ? 1 : 0) != 0, (String)"maxFilesPerMerge must be greater than 1");
            ((Builder)this.b).maxFilesPerMerge = value;
            return (S)this;
        }

        public S maxItemsPerFile(int value) {
            Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"maxItemsPerFile must be greater than 0");
            ((Builder)this.b).maxItemsPerFile = value;
            return (S)this;
        }

        public S unique(boolean value) {
            this.b.unique = value;
            return (S)this;
        }

        public S unique() {
            return this.unique(true);
        }

        public S logger(Consumer<? super String> logger) {
            Preconditions.checkNotNull(logger, (String)"logger cannot be null");
            ((Builder)this.b).logger = logger;
            return (S)this;
        }

        public S loggerStdOut() {
            return this.logger((Consumer<String>)new Consumer<String>(){

                @Override
                public void accept(String msg) {
                    System.out.println(ZonedDateTime.now().truncatedTo(ChronoUnit.MILLIS).format(Builder.DATE_TIME_PATTERN) + " " + msg);
                }
            });
        }

        public S bufferSize(int bufferSize) {
            Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (String)"bufferSize must be greater than 0");
            ((Builder)this.b).bufferSize = bufferSize;
            return (S)this;
        }

        public S tempDirectory(File directory) {
            Preconditions.checkNotNull((Object)directory, (String)"tempDirectory cannot be null");
            ((Builder)this.b).tempDirectory = directory;
            return (S)this;
        }
    }

    public static final class Builder3<T> {
        private final Builder<T> b;

        Builder3(Builder<T> b) {
            this.b = b;
        }

        public Builder3<T> filter(Predicate<? super T> predicate) {
            Function currentTransform = ((Builder)this.b).transform;
            return this.transform(r -> ((Reader)currentTransform.apply(r)).filter(predicate));
        }

        public Builder3<T> map(Function<? super T, ? extends T> mapper) {
            Function currentTransform = ((Builder)this.b).transform;
            return this.transform(r -> ((Reader)currentTransform.apply(r)).map(mapper));
        }

        public Builder3<T> flatMap(Function<? super T, ? extends List<? extends T>> mapper) {
            Function currentTransform = ((Builder)this.b).transform;
            return this.transform(r -> ((Reader)currentTransform.apply(r)).flatMap(mapper));
        }

        public Builder3<T> transform(Function<? super Reader<T>, ? extends Reader<? extends T>> transform) {
            Preconditions.checkNotNull(transform, (String)"transform cannot be null");
            Function currentTransform = ((Builder)this.b).transform;
            ((Builder)this.b).transform = r -> (Reader)transform.apply((Reader)currentTransform.apply(r));
            return this;
        }

        public Builder3<T> transformStream(Function<? super Stream<T>, ? extends Stream<? extends T>> transform) {
            Preconditions.checkNotNull(transform, (String)"transform cannot be null");
            Function currentTransform = ((Builder)this.b).transform;
            ((Builder)this.b).transform = r -> ((Reader)currentTransform.apply(r)).transform(transform);
            return this;
        }

        public Builder4<T> output(File output) {
            Preconditions.checkNotNull((Object)output, (String)"output cannot be null");
            ((Builder)this.b).output = output;
            return new Builder4<T>(this.b);
        }

        public Builder5<T> outputAsStream() {
            return new Builder5<T>(this.b);
        }
    }

    public static final class Builder2<T> {
        private final Builder<T> b;

        Builder2(Builder<T> b) {
            this.b = b;
        }

        public Builder3<T> input(Charset charset, String ... strings) {
            Preconditions.checkNotNull((Object)strings, (String)"string cannot be null");
            Preconditions.checkNotNull((Object)charset, (String)"charset cannot be null");
            List list = Arrays.asList(strings).stream().map(string -> new ByteArrayInputStream(string.getBytes(charset))).map(bis -> () -> bis).collect(Collectors.toList());
            return this.inputStreams(list);
        }

        public Builder3<T> input(String ... strings) {
            Preconditions.checkNotNull((Object)strings);
            return this.input(StandardCharsets.UTF_8, strings);
        }

        public Builder3<T> input(InputStream ... inputs) {
            ArrayList list = Lists.newArrayList();
            for (InputStream in : inputs) {
                list.add(() -> new NonClosingInputStream(in));
            }
            return this.inputStreams(list);
        }

        public Builder3<T> input(Supplier<? extends InputStream> input) {
            Preconditions.checkNotNull(input, (String)"input cannot be null");
            return this.inputStreams(Collections.singletonList(input));
        }

        public Builder3<T> input(File ... files) {
            return this.input(Arrays.asList(files));
        }

        public Builder3<T> input(List<File> files) {
            Preconditions.checkNotNull(files, (String)"files cannot be null");
            return this.inputStreams(files.stream().map(file -> this.supplier((File)file)).collect(Collectors.toList()));
        }

        public Builder3<T> inputStreams(List<? extends Supplier<? extends InputStream>> inputs) {
            Preconditions.checkNotNull(inputs);
            for (Supplier<? extends InputStream> supplier : inputs) {
                ((Builder)this.b).inputs.add(supplier);
            }
            return new Builder3<T>(this.b);
        }

        private Supplier<InputStream> supplier(File file) {
            return () -> {
                try {
                    return Sorter.openFile(file, ((Builder)this.b).bufferSize);
                }
                catch (FileNotFoundException e) {
                    throw new UncheckedIOException(e);
                }
            };
        }
    }

    public static final class Builder<T> {
        private static final DateTimeFormatter DATE_TIME_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.Sxxxx");
        private List<Supplier<? extends InputStream>> inputs = Lists.newArrayList();
        private final Serializer<T> serializer;
        private File output;
        private Comparator<? super T> comparator;
        private int maxFilesPerMerge = 100;
        private int maxItemsPerFile = 100000;
        private Consumer<? super String> logger = null;
        private int bufferSize = 8192;
        private File tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        private Function<? super Reader<T>, ? extends Reader<? extends T>> transform = r -> r;
        public boolean unique;

        Builder(Serializer<T> serializer) {
            this.serializer = serializer;
        }

        public Builder2<T> comparator(Comparator<? super T> comparator) {
            Preconditions.checkNotNull(comparator, (String)"comparator cannot be null");
            this.comparator = comparator;
            return new Builder2(this);
        }
    }
}

