/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bigsorter;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.davidmoten.bigsorter.CsvSerializer;
import com.github.davidmoten.bigsorter.FixedSizeRecordSerializer;
import com.github.davidmoten.bigsorter.JavaSerializer;
import com.github.davidmoten.bigsorter.JsonArraySerializer;
import com.github.davidmoten.bigsorter.LineDelimiter;
import com.github.davidmoten.bigsorter.LinesSerializer;
import com.github.davidmoten.bigsorter.Reader;
import com.github.davidmoten.bigsorter.Writer;
import com.github.davidmoten.guavamini.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;

public interface Serializer<T> {
    public Reader<T> createReader(InputStream var1);

    public Writer<T> createWriter(OutputStream var1);

    default public Reader<T> createReader(File file) throws FileNotFoundException {
        return this.createReader(new FileInputStream(file));
    }

    default public Writer<T> createWriter(File file) throws FileNotFoundException {
        return this.createWriter(new FileOutputStream(file));
    }

    public static Serializer<String> linesUtf8() {
        return Serializer.linesUtf8(LineDelimiter.LINE_FEED);
    }

    public static Serializer<String> linesUtf8(LineDelimiter delimiter) {
        Preconditions.checkNotNull((Object)((Object)delimiter));
        if (delimiter == LineDelimiter.LINE_FEED) {
            return LinesSerializer.LINES_UTF8_LF;
        }
        return LinesSerializer.LINES_UTF8_CR_LF;
    }

    public static Serializer<String> lines(Charset charset) {
        Preconditions.checkNotNull((Object)charset);
        return new LinesSerializer(charset, LineDelimiter.LINE_FEED);
    }

    public static Serializer<String> lines(Charset charset, LineDelimiter delimiter) {
        Preconditions.checkNotNull((Object)charset);
        Preconditions.checkNotNull((Object)((Object)delimiter));
        return new LinesSerializer(charset, delimiter);
    }

    public static <T extends Serializable> Serializer<T> java() {
        return JavaSerializer.instance();
    }

    public static Serializer<byte[]> fixedSizeRecord(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0);
        return new FixedSizeRecordSerializer(size);
    }

    public static Serializer<CSVRecord> csv(CSVFormat format, Charset charset) {
        Preconditions.checkNotNull((Object)format, (String)"format cannot be null");
        Preconditions.checkNotNull((Object)charset, (String)"charset cannot be null");
        return new CsvSerializer(format, charset);
    }

    public static Serializer<ObjectNode> jsonArray() {
        return JsonArraySerializer.INSTANCE;
    }
}

