/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bigsorter;

import com.github.davidmoten.bigsorter.Util;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Reader<T>
extends Closeable,
Iterable<T> {
    public T read() throws IOException;

    default public T readAutoClosing() throws IOException {
        T v = this.read();
        if (v == null) {
            this.close();
        }
        return v;
    }

    default public Reader<T> filter(final Predicate<? super T> predicate) {
        final Reader r = this;
        return new Reader<T>(){

            @Override
            public T read() throws IOException {
                Object t = r.read();
                while (t != null && !predicate.test(t)) {
                    t = r.read();
                }
                return t;
            }

            @Override
            public void close() throws IOException {
                r.close();
            }
        };
    }

    default public Reader<T> map(final Function<? super T, ? extends T> mapper) {
        final Reader r = this;
        return new Reader<T>(){

            @Override
            public T read() throws IOException {
                Object v = r.read();
                if (v == null) {
                    return null;
                }
                return mapper.apply(v);
            }

            @Override
            public void close() throws IOException {
                r.close();
            }
        };
    }

    default public Reader<T> flatMap(final Function<? super T, ? extends List<? extends T>> mapper) {
        final Reader r = this;
        return new Reader<T>(){
            List<? extends T> list;
            int index;

            @Override
            public T read() throws IOException {
                while (this.list == null || this.index == this.list.size()) {
                    Object t = r.read();
                    if (t == null) {
                        return null;
                    }
                    this.list = (List)mapper.apply(t);
                    this.index = 0;
                }
                return this.list.get(this.index++);
            }

            @Override
            public void close() throws IOException {
                r.close();
            }
        };
    }

    default public Reader<T> transform(Function<? super Stream<T>, ? extends Stream<? extends T>> function) {
        final Stream<? extends T> s = function.apply(this.stream());
        return new Reader<T>(){
            Iterator<? extends T> it;
            {
                this.it = s.iterator();
            }

            @Override
            public T read() throws IOException {
                if (this.it.hasNext()) {
                    return this.it.next();
                }
                return null;
            }

            @Override
            public void close() throws IOException {
                s.close();
            }
        };
    }

    @Override
    default public Iterator<T> iterator() {
        return new Iterator<T>(){
            T t;

            @Override
            public boolean hasNext() {
                this.load();
                return this.t != null;
            }

            @Override
            public T next() {
                this.load();
                if (this.t == null) {
                    throw new NoSuchElementException();
                }
                Object v = this.t;
                this.t = null;
                return v;
            }

            void load() {
                if (this.t == null) {
                    try {
                        this.t = Reader.this.read();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
        };
    }

    default public Stream<T> stream() {
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false).onClose(() -> Util.close(this));
    }
}

