/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.renderer;

import com.github.cukedoctor.api.CukedoctorDocumentBuilder;
import com.github.cukedoctor.api.model.Comment;
import com.github.cukedoctor.api.model.DocString;
import com.github.cukedoctor.api.model.Output;
import com.github.cukedoctor.api.model.Result;
import com.github.cukedoctor.api.model.Row;
import com.github.cukedoctor.api.model.Status;
import com.github.cukedoctor.api.model.Step;
import com.github.cukedoctor.config.CukedoctorConfig;
import com.github.cukedoctor.renderer.AbstractBaseRenderer;
import com.github.cukedoctor.spi.StepsRenderer;
import com.github.cukedoctor.util.Assert;
import com.github.cukedoctor.util.Constants;
import com.github.cukedoctor.util.Formatter;
import java.util.List;

public class CukedoctorStepsRenderer
extends AbstractBaseRenderer
implements StepsRenderer {
    public CukedoctorStepsRenderer() {
    }

    public CukedoctorStepsRenderer(CukedoctorConfig cukedoctorConfig) {
        this.cukedoctorConfig = cukedoctorConfig;
    }

    @Override
    public String renderSteps(List<Step> steps) {
        this.docBuilder.clear();
        this.docBuilder.textLine("==========");
        for (Step step : steps) {
            this.docBuilder.append(step.getKeyword(), "::", Constants.newLine());
            this.docBuilder.append(step.getName() + " ", Status.getStatusIcon(step.getStatus()));
            if (!this.cukedoctorConfig.isHideStepTime().booleanValue()) {
                this.docBuilder.append(this.renderStepTime(step.getResult()));
            }
            this.docBuilder.append(this.renderStepTable(step));
            if (Assert.notNull(step.getDocString()) && Assert.hasText(step.getDocString().getValue())) {
                if (step.hasDiscreteComment()) {
                    this.renderDiscreteSidebarBlock(step.getDocString());
                } else {
                    this.renderListingBlock(step.getDocString());
                }
            }
            if (step.getResult() != null && !Status.passed.equals((Object)step.getStatus()) && step.getResult().getErrorMessage() != null) {
                this.docBuilder.append(Constants.newLine(), "IMPORTANT: ", step.getResult().getErrorMessage(), Constants.newLine());
            }
            this.renderOutput(step);
            this.enrichStep(step);
        }
        this.docBuilder.textLine("==========").newLine();
        return this.docBuilder.toString();
    }

    void renderOutput(Step step) {
        if (step.hasOutput()) {
            this.docBuilder.textLine(Constants.Markup.listing());
            for (Output output : step.getOutput()) {
                this.docBuilder.textLine(output.getValue());
            }
            this.docBuilder.textLine(Constants.Markup.listing());
        }
    }

    private void renderListingBlock(DocString docString) {
        this.docBuilder.append(Constants.Markup.listing(), Constants.newLine(), Constants.newLine());
        this.docBuilder.append(docString.getValue().replaceAll("\\n", Constants.newLine()));
        this.docBuilder.append(Constants.newLine(), Constants.newLine(), Constants.Markup.listing(), Constants.newLine());
    }

    private void renderDiscreteSidebarBlock(DocString docString) {
        this.docBuilder.append("******", Constants.newLine(), Constants.newLine());
        String[] lines = docString.getValue().replaceAll("\\*\\*\\*\\*", "*****").replaceAll(Constants.Markup.exampleBlock(), Constants.Markup.exampleBlock() + "=").split("\\n");
        boolean isListing = false;
        boolean isTable = false;
        for (String line : lines) {
            if (!isListing) {
                line = line.replaceAll("\r", "");
            }
            if (isListing) {
                if (line.contains("----")) {
                    isListing = false;
                }
                this.docBuilder.textLine(line);
                continue;
            }
            if (!isListing && line.contains("----")) {
                isListing = true;
                this.docBuilder.textLine(line);
                continue;
            }
            if (line.startsWith("<") && line.endsWith(">")) {
                this.docBuilder.textLine(line);
                continue;
            }
            if (line.startsWith("======")) {
                this.docBuilder.textLine(line);
                continue;
            }
            if (isTable) {
                this.docBuilder.textLine(line);
                if (!line.contains(Constants.Markup.table())) continue;
                isTable = false;
                continue;
            }
            if (line.contains(Constants.Markup.table())) {
                isTable = true;
            }
            this.docBuilder.textLine("[discrete]").textLine(line);
        }
        this.docBuilder.append(Constants.newLine(), Constants.newLine(), "******", Constants.newLine());
    }

    private void enrichStep(Step step) {
        if (step != null && step.hasComments()) {
            int numComments = step.getComments().size();
            for (Comment comment : step.getComments()) {
                if (Assert.hasText(comment.getValue()) && comment.getValue().contains("{") && comment.getValue().contains("}")) {
                    String line = comment.getValue();
                    if (comment.getValue().contains("[source") || line.contains("====") || line.contains(Constants.Markup.listing()) || line.startsWith("<") && line.endsWith(">")) {
                        this.docBuilder.textLine(line.replaceAll("\\n", Constants.newLine()).replaceAll("#\\{", "").replaceAll("# \\{", "").replaceAll("}", ""));
                    } else {
                        this.docBuilder.textLine(line.replaceAll("\\n", Constants.newLine()).replaceAll("#\\{", Constants.newLine()).replaceAll("# \\{", Constants.newLine()).replaceAll("}", ""));
                    }
                }
                if (step.getComments().indexOf(comment) != numComments - 1) continue;
                this.docBuilder.newLine();
            }
        }
    }

    String renderStepTime(Result result) {
        if (result == null || result.getDuration() == null) {
            return "";
        }
        return " [small right]#(" + Formatter.formatTime(result.getDuration()) + ")#";
    }

    String renderStepTable(Step step) {
        CukedoctorDocumentBuilder builder = CukedoctorDocumentBuilder.Factory.newInstance();
        builder.newLine();
        if (Assert.notEmpty(step.getRows())) {
            builder.newLine();
            builder.append("[cols=\"" + step.getRows()[0].getCells().length + "*\", options=\"header\"]").newLine();
            builder.textLine(Constants.Markup.table());
            Row header = step.getRows()[0];
            for (String col : header.getCells()) {
                builder.append(Constants.Markup.tableCol(), col).newLine();
            }
            for (int i = 1; i < step.getRows().length; ++i) {
                for (String cell : step.getRows()[i].getCells()) {
                    builder.append(Constants.Markup.tableCol(), cell).newLine();
                }
            }
            builder.textLine(Constants.Markup.table());
            builder.newLine();
        }
        return builder.toString();
    }
}

