/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.renderer;

import com.github.cukedoctor.api.model.Example;
import com.github.cukedoctor.api.model.Row;
import com.github.cukedoctor.api.model.Scenario;
import com.github.cukedoctor.renderer.AbstractBaseRenderer;
import com.github.cukedoctor.spi.ExamplesRenderer;
import com.github.cukedoctor.util.Constants;

public class CukedoctorExamplesRenderer
extends AbstractBaseRenderer
implements ExamplesRenderer {
    @Override
    public String renderScenarioExamples(Scenario scenario) {
        this.docBuilder.clear();
        if (scenario.hasExamples()) {
            this.docBuilder.newLine();
            for (Example example : scenario.getExamples()) {
                this.docBuilder.append("." + (example.getName() == null || "".equals(example.getName()) ? "Example" : example.getName()), Constants.newLine());
                this.docBuilder.append("[cols=\"" + example.getRows()[0].getCells().length + "*\", options=\"header\"]", Constants.newLine());
                this.docBuilder.append(Constants.Markup.table(), Constants.newLine());
                Row header = example.getRows()[0];
                for (String col : header.getCells()) {
                    this.docBuilder.append(Constants.Markup.tableCol(), col, Constants.newLine());
                }
                for (int i = 1; i < example.getRows().length; ++i) {
                    for (String cell : example.getRows()[i].getCells()) {
                        this.docBuilder.append(Constants.Markup.tableCol(), cell, Constants.newLine());
                    }
                }
                this.docBuilder.append(Constants.Markup.table(), Constants.newLine(), Constants.newLine());
            }
        }
        return this.docBuilder.toString();
    }
}

