/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.config;

import com.github.cukedoctor.api.DocumentAttributes;
import com.github.cukedoctor.config.LayoutConfig;
import java.io.InputStream;
import org.yaml.snakeyaml.Yaml;

public class GlobalConfig {
    private static GlobalConfig instance;
    private DocumentAttributes documentAttributes;
    private LayoutConfig layoutConfig;

    private GlobalConfig() {
    }

    public static GlobalConfig getInstance() {
        if (instance == null) {
            instance = GlobalConfig.createInstance();
        }
        return instance;
    }

    public static GlobalConfig newInstance() {
        return GlobalConfig.createInstance();
    }

    private static GlobalConfig createInstance() {
        GlobalConfig globalConfig = null;
        InputStream customConfiguration = Thread.currentThread().getContextClassLoader().getResourceAsStream("cukedoctor.yml");
        if (customConfiguration != null) {
            globalConfig = (GlobalConfig)new Yaml().loadAs(customConfiguration, GlobalConfig.class);
        }
        if (globalConfig == null) {
            globalConfig = (GlobalConfig)new Yaml().loadAs(GlobalConfig.class.getResourceAsStream("/config/cukedoctor.yml"), GlobalConfig.class);
        }
        return globalConfig;
    }

    public DocumentAttributes getDocumentAttributes() {
        return this.documentAttributes;
    }

    public void setDocumentAttributes(DocumentAttributes documentAttributes) {
        this.documentAttributes = documentAttributes;
    }

    public LayoutConfig getLayoutConfig() {
        return this.layoutConfig;
    }

    public void setLayoutConfig(LayoutConfig layoutConfig) {
        this.layoutConfig = layoutConfig;
    }
}

