/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.config;

import com.github.cukedoctor.config.GlobalConfig;
import com.github.cukedoctor.util.Assert;
import com.github.cukedoctor.util.Constants;
import java.io.Serializable;

public class CukedoctorConfig
implements Serializable {
    private Integer errorMessageSize = Constants.getProp("ERROR_MESSAGE_SIZE", Integer.class);
    private String introChapterDir;
    private String customizationDir;
    private String introChapterRelativePath;
    private Boolean hideFeaturesSection;
    private Boolean hideStepTime;
    private Boolean hideSummarySection;
    private Boolean hideScenarioKeyword;
    private Boolean hideTags;
    private Boolean disableMinMaxExtension;

    public CukedoctorConfig() {
        if (this.errorMessageSize == null) {
            this.errorMessageSize = GlobalConfig.getInstance().getLayoutConfig().getErrorMessageLength();
        }
        this.introChapterDir = System.getProperty("INTRO_CHAPTER_DIR");
        if (!Assert.hasText(this.introChapterDir)) {
            this.introChapterDir = Constants.BASE_DIR;
        }
        this.customizationDir = System.getProperty("CUKEDOCTOR_CUSTOMIZATION_DIR");
        if (!Assert.hasText(this.customizationDir)) {
            this.customizationDir = Constants.BASE_DIR;
        }
        this.hideSummarySection = Constants.getBooleanProperty("HIDE_SUMMARY_SECTION");
        if (this.hideSummarySection == null) {
            this.hideSummarySection = GlobalConfig.getInstance().getLayoutConfig().isHideSummarySection();
        }
        this.hideFeaturesSection = Constants.getBooleanProperty("HIDE_FEATURES_SECTION");
        if (this.hideFeaturesSection == null) {
            this.hideFeaturesSection = GlobalConfig.getInstance().getLayoutConfig().isHideFeaturesSection();
        }
        this.hideStepTime = Constants.getBooleanProperty("HIDE_STEP_TIME");
        if (this.hideStepTime == null) {
            this.hideStepTime = GlobalConfig.getInstance().getLayoutConfig().isHideStepTime();
        }
        this.hideScenarioKeyword = Constants.getBooleanProperty("HIDE_SCENARIO_KEYWORD");
        if (this.hideScenarioKeyword == null) {
            this.hideScenarioKeyword = GlobalConfig.getInstance().getLayoutConfig().isHideScenarioKeyword();
        }
        this.hideTags = Constants.getBooleanProperty("HIDE_TAGS");
        if (this.hideTags == null) {
            this.hideTags = GlobalConfig.getInstance().getLayoutConfig().isHideTags();
        }
        this.introChapterRelativePath = System.getProperty("INTRO_CHAPTER_RELATIVE_PATH");
        this.disableMinMaxExtension = System.getProperty("cukedoctor.disable.minmax") != null || System.getProperty("cukedoctor.disable-extensions") != null;
    }

    public Integer getErrorMessageSize() {
        return this.errorMessageSize;
    }

    public String getIntroChapterDir() {
        return this.introChapterDir;
    }

    public String getCustomizationDir() {
        return this.customizationDir;
    }

    public Boolean isHideFeaturesSection() {
        return this.hideFeaturesSection;
    }

    public Boolean isHideStepTime() {
        return this.hideStepTime;
    }

    public Boolean isHideSummarySection() {
        return this.hideSummarySection;
    }

    public Boolean isHideScenarioKeyword() {
        return this.hideScenarioKeyword;
    }

    public Boolean isHideTags() {
        return this.hideTags;
    }

    public Boolean isDisableMinMaxExtension() {
        return this.disableMinMaxExtension;
    }

    public String getIntroChapterRelativePath() {
        return this.introChapterRelativePath;
    }

    public CukedoctorConfig setCustomizationDir(String customizationDir) {
        this.customizationDir = customizationDir;
        return this;
    }

    public CukedoctorConfig setDisableMinMaxExtension(Boolean disableMinMaxExtension) {
        this.disableMinMaxExtension = disableMinMaxExtension;
        return this;
    }

    public CukedoctorConfig setHideScenarioKeyword(Boolean hideScenarioKeyword) {
        this.hideScenarioKeyword = hideScenarioKeyword;
        return this;
    }

    public CukedoctorConfig setErrorMessageSize(Integer errorMessageSize) {
        this.errorMessageSize = errorMessageSize;
        return this;
    }

    public CukedoctorConfig setIntroChapterDir(String introChapterDir) {
        this.introChapterDir = introChapterDir;
        return this;
    }

    public CukedoctorConfig setIntroChapterRelativePath(String introChapterRelativePath) {
        this.introChapterRelativePath = introChapterRelativePath;
        return this;
    }

    public CukedoctorConfig setHideFeaturesSection(Boolean hideFeaturesSection) {
        this.hideFeaturesSection = hideFeaturesSection;
        return this;
    }

    public CukedoctorConfig setHideStepTime(Boolean hideStepTime) {
        this.hideStepTime = hideStepTime;
        return this;
    }

    public CukedoctorConfig setHideSummarySection(Boolean hideSummarySection) {
        this.hideSummarySection = hideSummarySection;
        return this;
    }

    public CukedoctorConfig setHideTags(Boolean hideTags) {
        this.hideTags = hideTags;
        return this;
    }
}

