/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.api;

import com.github.cukedoctor.api.model.Status;
import com.github.cukedoctor.api.model.Step;
import com.github.cukedoctor.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class StepResults {
    private List<Step> allSteps;
    private Map<Status, AtomicInteger> statusCounter;
    private long totalDuration;

    public StepResults(List<Step> allSteps, Map<Status, AtomicInteger> statusCounter, long totalDuration) {
        this.allSteps = allSteps;
        this.statusCounter = statusCounter;
        this.totalDuration = totalDuration;
    }

    public int getNumberOfSteps() {
        return this.allSteps.size();
    }

    public int getNumberOfPasses() {
        return this.statusCounter.get((Object)Status.passed).intValue();
    }

    public int getNumberOfFailures() {
        return this.statusCounter.get((Object)Status.failed).intValue();
    }

    public int getNumberOfUndefined() {
        return this.statusCounter.get((Object)Status.undefined).intValue();
    }

    public int getNumberOfPending() {
        return this.statusCounter.get((Object)Status.pending).intValue();
    }

    public int getNumberOfSkipped() {
        return this.statusCounter.get((Object)Status.skipped).intValue();
    }

    public int getNumberOfMissing() {
        return this.statusCounter.get((Object)Status.missing).intValue();
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    public String getTotalDurationAsString() {
        return Formatter.formatTime(this.totalDuration);
    }
}

