/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.pepxml;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamReader;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.pepxml.PepXmlStreamIterator;
import umich.ms.fileio.filetypes.pepxml.jaxb.standard.MsmsPipelineAnalysis;
import umich.ms.fileio.filetypes.pepxml.jaxb.standard.MsmsRunSummary;
import umich.ms.util.jaxb.JaxbUtils;

public class PepXmlParser {
    protected static final String TAG_MSMS_RUN_SUMMARY = "msms_run_summary";
    protected static final String TAG_MSMS_PIPELINE_ANALYSIS = "msms_pipeline_analysis";

    private PepXmlParser() {
    }

    public static MsmsPipelineAnalysis parse(Path path) throws FileParsingException {
        try {
            XMLStreamReader xsr = JaxbUtils.createXmlStreamReader(path, false);
            MsmsPipelineAnalysis msmsPipelineAnalysis = JaxbUtils.unmarshal(MsmsPipelineAnalysis.class, xsr);
            return msmsPipelineAnalysis;
        }
        catch (JAXBException e) {
            throw new FileParsingException(String.format("JAXB parsing of PepXML file failed (%s)", path.toAbsolutePath().toString()), e);
        }
    }

    public static Iterator<MsmsRunSummary> parse(InputStream is) throws FileParsingException {
        return PepXmlStreamIterator.create(is);
    }

    public static void main(String[] args) throws FileParsingException {
        List paths;
        if (args.length == 0) {
            System.err.println("Supply arguments that are paths to pepxml files");
        }
        if ((paths = Arrays.stream(args).map(s -> Paths.get(s, new String[0])).collect(Collectors.toList())).stream().anyMatch(p -> !Files.exists(p, new LinkOption[0]))) {
            System.err.println("Not all input files exist");
        }
        for (Path p2 : paths) {
            System.out.println("\nParsing: " + p2.toString());
            MsmsPipelineAnalysis pepxml = PepXmlParser.parse(p2);
            int sum = pepxml.getMsmsRunSummary().stream().flatMapToInt(msmsRunSummary -> msmsRunSummary.getSpectrumQuery().stream().flatMapToInt(spectrumQuery -> spectrumQuery.getSearchResult().stream().mapToInt(value -> value.getSearchHit().size()))).sum();
            System.out.printf("Done, found %d PSMs\n", sum);
        }
    }
}

