/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.util.base64;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import umich.ms.util.base64.Base64DecodingException;

public class Base64Slow {
    public static final String version = "1.2";
    protected static final byte[] base64Chars;
    protected static final byte[] reverseBase64Chars;
    private static final int END_OF_INPUT = -1;
    private static final int NON_BASE_64 = -1;
    private static final int NON_BASE_64_WHITESPACE = -2;
    private static final int NON_BASE_64_PADDING = -3;

    private Base64Slow() {
    }

    public static String encode(String string) {
        return new String(Base64Slow.encode(string.getBytes()));
    }

    public static String encode(String string, String enc) throws UnsupportedEncodingException {
        return new String(Base64Slow.encode(string.getBytes(enc)), enc);
    }

    public static String encodeToString(byte[] bytes) {
        return Base64Slow.encodeToString(bytes, false);
    }

    public static String encodeToString(byte[] bytes, boolean lineBreaks) {
        try {
            return new String(Base64Slow.encode(bytes, lineBreaks), "ASCII");
        }
        catch (UnsupportedEncodingException iex) {
            throw new RuntimeException(iex);
        }
    }

    public static byte[] encode(byte[] bytes) {
        return Base64Slow.encode(bytes, false);
    }

    public static byte[] encode(byte[] bytes, boolean lineBreaks) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        int length = bytes.length;
        int mod = length % 3;
        if (mod != 0) {
            length += 3 - mod;
        }
        length = length * 4 / 3;
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        try {
            Base64Slow.encode(in, out, lineBreaks);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        return out.toByteArray();
    }

    public static void encode(InputStream in, OutputStream out) throws IOException {
        Base64Slow.encode(in, out, true);
    }

    public static void encode(InputStream in, OutputStream out, boolean lineBreaks) throws IOException {
        int[] inBuffer = new int[3];
        int lineCount = 0;
        boolean done = false;
        while (!done && (inBuffer[0] = in.read()) != -1) {
            inBuffer[1] = in.read();
            inBuffer[2] = in.read();
            out.write(base64Chars[inBuffer[0] >> 2]);
            if (inBuffer[1] != -1) {
                out.write(base64Chars[inBuffer[0] << 4 & 0x30 | inBuffer[1] >> 4]);
                if (inBuffer[2] != -1) {
                    out.write(base64Chars[inBuffer[1] << 2 & 0x3C | inBuffer[2] >> 6]);
                    out.write(base64Chars[inBuffer[2] & 0x3F]);
                } else {
                    out.write(base64Chars[inBuffer[1] << 2 & 0x3C]);
                    out.write(61);
                    done = true;
                }
            } else {
                out.write(base64Chars[inBuffer[0] << 4 & 0x30]);
                out.write(61);
                out.write(61);
                done = true;
            }
            if (!lineBreaks || (lineCount += 4) < 76) continue;
            out.write(10);
            lineCount = 0;
        }
        if (lineBreaks && lineCount >= 1) {
            out.write(10);
            lineCount = 0;
        }
        out.flush();
    }

    public static String decode(String string) {
        return new String(Base64Slow.decode(string.getBytes()));
    }

    public static String decode(String string, String enc) throws UnsupportedEncodingException {
        return new String(Base64Slow.decode(string.getBytes(enc)), enc);
    }

    public static String decode(String string, String encIn, String encOut) throws UnsupportedEncodingException {
        return new String(Base64Slow.decode(string.getBytes(encIn)), encOut);
    }

    public static String decodeToString(String string) {
        return new String(Base64Slow.decode(string.getBytes()));
    }

    public static String decodeToString(String string, String enc) throws UnsupportedEncodingException {
        return new String(Base64Slow.decode(string.getBytes(enc)), enc);
    }

    public static String decodeToString(String string, String encIn, String encOut) throws UnsupportedEncodingException {
        return new String(Base64Slow.decode(string.getBytes(encIn)), encOut);
    }

    public static void decodeToStream(String string, OutputStream out) throws IOException {
        Base64Slow.decode(new ByteArrayInputStream(string.getBytes()), out);
    }

    public static void decodeToStream(String string, String enc, OutputStream out) throws UnsupportedEncodingException, IOException {
        Base64Slow.decode(new ByteArrayInputStream(string.getBytes(enc)), out);
    }

    public static byte[] decodeToBytes(String string) {
        return Base64Slow.decode(string.getBytes());
    }

    public static byte[] decodeToBytes(String string, String enc) throws UnsupportedEncodingException {
        return Base64Slow.decode(string.getBytes(enc));
    }

    public static String decodeToString(byte[] bytes) {
        return new String(Base64Slow.decode(bytes));
    }

    public static String decodeToString(byte[] bytes, String enc) throws UnsupportedEncodingException {
        return new String(Base64Slow.decode(bytes), enc);
    }

    public static byte[] decodeToBytes(byte[] bytes) {
        return Base64Slow.decode(bytes);
    }

    public static byte[] decode(byte[] bytes) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        int length = bytes.length;
        int mod = length % 4;
        if (mod != 0) {
            length += 4 - mod;
        }
        length = length * 3 / 4;
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        try {
            Base64Slow.decode(in, out, false);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        return out.toByteArray();
    }

    public static void decode(byte[] bytes, OutputStream out) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        Base64Slow.decode(in, out, false);
    }

    public static void decodeToStream(byte[] bytes, OutputStream out) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        Base64Slow.decode(in, out, false);
    }

    private static final int readBase64(InputStream in, boolean throwExceptions) throws IOException {
        int read;
        int numPadding = 0;
        do {
            if ((read = in.read()) == -1) {
                return -1;
            }
            read = reverseBase64Chars[(byte)read];
            if (throwExceptions && (read == -1 || numPadding > 0 && read > -1)) {
                throw new Base64DecodingException(MessageFormat.format("Unexpected char", "'" + (char)read + "' (0x" + Integer.toHexString(read) + ")"), (char)read);
            }
            if (read != -3) continue;
            ++numPadding;
        } while (read <= -1);
        return read;
    }

    public static byte[] decodeToBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Base64Slow.decode(in, out, false);
        return out.toByteArray();
    }

    public static String decodeToString(InputStream in) throws IOException {
        return new String(Base64Slow.decodeToBytes(in));
    }

    public static String decodeToString(InputStream in, String enc) throws IOException {
        return new String(Base64Slow.decodeToBytes(in), enc);
    }

    public static void decode(InputStream in, OutputStream out) throws IOException {
        Base64Slow.decode(in, out, true);
    }

    public static void decode(InputStream in, OutputStream out, boolean throwExceptions) throws IOException {
        int[] inBuffer = new int[4];
        boolean done = false;
        while (!done && (inBuffer[0] = Base64Slow.readBase64(in, throwExceptions)) != -1 && (inBuffer[1] = Base64Slow.readBase64(in, throwExceptions)) != -1) {
            inBuffer[2] = Base64Slow.readBase64(in, throwExceptions);
            inBuffer[3] = Base64Slow.readBase64(in, throwExceptions);
            out.write(inBuffer[0] << 2 | inBuffer[1] >> 4);
            if (inBuffer[2] != -1) {
                out.write(inBuffer[1] << 4 | inBuffer[2] >> 2);
                if (inBuffer[3] != -1) {
                    out.write(inBuffer[2] << 6 | inBuffer[3]);
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        out.flush();
    }

    public static boolean isBase64(byte[] bytes) {
        try {
            return Base64Slow.isBase64(new ByteArrayInputStream(bytes));
        }
        catch (IOException x) {
            return false;
        }
    }

    public static boolean isBase64(String string) {
        return Base64Slow.isBase64(string.getBytes());
    }

    public static boolean isBase64(String string, String enc) throws UnsupportedEncodingException {
        return Base64Slow.isBase64(string.getBytes(enc));
    }

    public static boolean isBase64(File fIn) throws IOException {
        return Base64Slow.isBase64(new BufferedInputStream(new FileInputStream(fIn)));
    }

    public static boolean isBase64(InputStream in) throws IOException {
        int read;
        long numBase64Chars = 0L;
        int numPadding = 0;
        while ((read = in.read()) != -1) {
            if ((read = reverseBase64Chars[read]) == -1) {
                return false;
            }
            if (read == -2) continue;
            if (read == -3) {
                ++numPadding;
                ++numBase64Chars;
                continue;
            }
            if (numPadding > 0) {
                return false;
            }
            ++numBase64Chars;
        }
        if (numBase64Chars == 0L) {
            return false;
        }
        return numBase64Chars % 4L == 0L;
    }

    static {
        int i;
        base64Chars = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        reverseBase64Chars = new byte[256];
        for (i = 0; i < reverseBase64Chars.length; ++i) {
            Base64Slow.reverseBase64Chars[i] = -1;
        }
        for (i = 0; i < base64Chars.length; i = (int)((byte)(i + 1))) {
            Base64Slow.reverseBase64Chars[Base64Slow.base64Chars[i]] = i;
        }
        Base64Slow.reverseBase64Chars[32] = -2;
        Base64Slow.reverseBase64Chars[10] = -2;
        Base64Slow.reverseBase64Chars[13] = -2;
        Base64Slow.reverseBase64Chars[9] = -2;
        Base64Slow.reverseBase64Chars[12] = -2;
        Base64Slow.reverseBase64Chars[61] = -3;
    }
}

