/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.agilent.cef;

import java.nio.file.Path;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamReader;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.agilent.cef.jaxb.CEF;
import umich.ms.util.jaxb.JaxbUtils;

public class AgilentCefParser {
    public static CEF parse(Path path) throws FileParsingException {
        XMLStreamReader xsr = null;
        try {
            xsr = JaxbUtils.createXmlStreamReader(path, false);
        }
        catch (JAXBException e) {
            throw new FileParsingException("Could not create XML Stream Reader for Agilent CEF file", e);
        }
        CEF cef = null;
        try {
            cef = JaxbUtils.unmarshal(CEF.class, xsr);
        }
        catch (JAXBException e) {
            throw new FileParsingException("Could not unmarshall CEF.class from XML", e);
        }
        return cef;
    }
}

