/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.datatypes.scancollection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import umich.ms.datatypes.scan.IScan;

public class ScanIndex
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ScanIndex.class);
    private static final long serialVersionUID = -372131408871860232L;
    protected TreeMap<Integer, IScan> num2scan = new TreeMap();
    protected TreeMap<Double, List<IScan>> rt2scan = new TreeMap();

    public TreeMap<Integer, IScan> getNum2scan() {
        return this.num2scan;
    }

    public TreeMap<Double, List<IScan>> getRt2scan() {
        return this.rt2scan;
    }

    public IScan add(IScan scan) {
        int num = scan.getNum();
        IScan oldScan = this.getNum2scan().put(num, scan);
        log.debug("Adding scan #{} to ScanIndex. num2scan map already contained a scan for scanNum: {}", (Object)num, (Object)num);
        Double rt = scan.getRt();
        TreeMap<Double, List<IScan>> rt2scan = this.getRt2scan();
        if (scan.getRt() != null) {
            List<IScan> scans = rt2scan.get(rt);
            if (scans == null) {
                scans = new ArrayList<IScan>(1);
                scans.add(scan);
                this.getRt2scan().put(rt, scans);
            } else {
                boolean replaced = false;
                for (int i = 0; i < scans.size(); ++i) {
                    IScan s = scans.get(i);
                    if (s.getNum() != scan.getNum()) continue;
                    scans.set(i, scan);
                    replaced = true;
                    break;
                }
                if (!replaced) {
                    scans.add(scan);
                }
            }
        } else {
            log.debug("Adding scan # to ScanIndex. No RT.", (Object)num);
        }
        return oldScan;
    }
}

